/**
 * @file    SmartApp.h
 * @brief   Application call
 * @author  Bin Wang
 * @version 1.0
 */
 
#ifndef SMART_APP_SINGLE_H
#define SMART_APP_SINGLE_H

#include "mDot.h"
#include "MIUN.LoRa.h"


namespace MIUN
{
    
class SmartAppSingle
{
/*** Parameters ***/
private:
    static const std::string emptyPayload;
    static const int defaultPort; 


/*** constructor ***/
public:
    SmartAppSingle();

/*** Components ***/
private:
    MIUN::LoRa lora;

/*** Functions ***/
public:
    void setSleepTime(uint32_t inSleepTime);
    void startRunning();

protected:
    std::string sendReceive(std::string payload, int port, int* receivePort);
    
/*** Virtual Function ***/
public:
     virtual uint8_t measuredBattery();
     virtual void    execute();


};

} // End of namespace

#endif