#include "AppUnit.h"

std::queue<MIUN::SendPayload> MIUN::AppUnit::payloadQueue;

MIUN::AppUnit::AppUnit(uint8_t in_appNumber)
{
    if(in_appNumber>220)
    {
        appNumber = 220;
    }
    else
    {
        appNumber = in_appNumber;
    }
    
}

 MIUN::AppUnit::~AppUnit()
{
}


uint8_t MIUN::AppUnit::getAppNumber()
{
    return appNumber;
}


void MIUN::AppUnit::run(std::string payload)
{
    logInfo("Receive Payload: %s in application %u. Please overload \'run(std::string payload)\' method to solve them.", payload.c_str(),appNumber);
}

void MIUN::AppUnit::interrupt()
{
    logInfo("Enter Interrupt");
}

void MIUN::AppUnit::send(std::string payload)
{
    SendPayload sendPayload(payload,appNumber);
    payloadQueue.push(sendPayload);
}


MIUN::SendPayload MIUN::AppUnit::getSendPayload()
{
    SendPayload sendPayload = payloadQueue.front();
    payloadQueue.pop();
    return sendPayload;
}

bool MIUN::AppUnit::hasSendPayload()
{
    return !payloadQueue.empty();
}

