/**
 * @file    SmartApp.h
 * @brief   Application call
 * @author  Bin Wang
 * @version 1.0
 */
 
#ifndef SMART_APP_H
#define SMART_APP_H

#include "mDot.h"
#include "MIUN.LoRa.h"
#include "AppUnit.h"


namespace MIUN
{
    
class SmartApp
{
/*** Parameters ***/
private:
    static const std::string emptyPayload;
    static const int defaultPort; 


/*** constructor ***/
public:
    SmartApp();

/*** Components ***/
private:
    MIUN::LoRa lora;
    std::map <uint8_t, AppUnit&> appMap;
    
public:
    void addApp(AppUnit& app);
    void setSleepTime(uint32_t inSleepTime);
    void startRunning();
    void showAppMap();
    
/*** Virtual Function ***/
public:
     virtual uint8_t measuredBattery();

/*** Handle ***/


private:
    void heartBeat();
    void triggerApp();
    void checkInterrupt();


    // test
public:
    void testThread();
    void testSaveFile();
    void testSendAndReceive();
    void staQuality();
    void unConfirmedTest();
    void testMacCommand();
    void adaptSFTest();
};

} // End of namespace

#endif