/**
 * @file    LoRa.h
 * @brief   Application call
 * @author  Bin Wang
 * @version 1.0
 */
 
#ifndef MIUN_LORA_H
#define MIUN_LORA_H

#include "mDot.h"
#include "mDotEvent.h"


namespace MIUN
{
    
class LoRa;

class MacCommandEvent : public mDotEvent
{
/*** CommandType ***/
private:
    enum CommmandType 
    {
        decreaseSF = 0x80,
        increaseSF = 0x81,
        changeSleepTime = 0x82,
    };
    
    enum CommmandType_length 
    {
        decreaseSF_length = 1,
        increaseSF_length = 1,
        changeSleepTime_length = 5,
    };
    


private:
    LoRa& loraHandle;
public:
    MacCommandEvent(LoRa& loraHandle);
 
    virtual ~MacCommandEvent() {}
 
    virtual void RxDone(uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr, lora::DownlinkControl ctrl, uint8_t slot);

    virtual uint8_t MeasureBattery(); 
    
private:
    void processSFDecrease(uint8_t *payload);
    void processSFIncrease(uint8_t *payload);
    void processChangeSleepTm(uint8_t *macCommand);
    void processqueryBatteryLevel(uint8_t *macCommand);
    
    void sendCommand (uint8_t* command, int commandLength);
};

class LoRa
{
/*** Parameters ***/
private:
    uint8_t rejoinTimes;
    uint8_t retransTimes;
    uint8_t installSF;
    uint32_t sleepTime;
    uint32_t defaultSleepTime;
    
    int receivePort;
    
    uint8_t batteryLevel;

/*** component ***/
private:
    mDot* dot;
    MacCommandEvent macCommandEvent;

/*** constructor ***/
public:
    LoRa();

/*** Handle Functins ***/

public:
    /*** Information ***/
    void showInfo();
    
    /*** sleep ***/
    void sleep();
    void sleep(const uint32_t& interval_s);
    void sleepWaitingNextFreeChannel();
    
    /*** Network ***/
    bool joinNetwork ();
    bool send_basic(std::string input_data);
    bool send(std::string input_data, int port);
    std::string receive(int* port);
    std::string sendReceive(std::string payload, int port, int* receivePort);
    
    /*** check ***/
    bool checkSleepTime(uint32_t sleepTime);  
       
    /*** Setting ***/
    void reset();
    
    void networkConfig(std::string network_name, 
                                std::string network_passphrase, 
                                uint8_t     retransTimes,
                                uint8_t     joinDelay,
                                bool        ADR,
                                uint8_t     sf); // Include reset and setting save.
    
    /*** getting ***/
    
        
    /*** Setting ***/
public:

    void setBatteryLevel(uint8_t batteryLevel);

    void setFPending(bool isPending);
    
    void setDefaultSleepTime(uint32_t inSleepTime);
    
    void setSleepTime(uint32_t inSleepTime);
    
    bool increaseSF();
    
    bool decreaseSF();
    
    void resetSF();

    void changeSF(const uint8_t& sf);

    void changeAdaptSF(bool adaptSF);

    void changeModeToAUTO_OTA();
    
    void changeNetworkName(const std::string& network_name);
    
    void changePassword(const std::string& networkKey);
    
    void changeAck(const uint8_t& retries);
    
    void changeJoinDelay(uint8_t joinDelay);
    
    void changePublicNetwork(bool isPublicNetwork);    
    
    /*** Save & get***/
private:
    void saveSetting();
    /*
    void saveSleepTime(uint32_t sleepTime);
    uint32_t readSleepTime();
    */

    
    /*** Get ***/
public:
    mDot& getHandler();
    
/*** Private Functions ***/
private:
    bool tryConnectNet();
    
friend class MacCommandEvent;
};





} // CLOSE NAMESPACE



#endif