#include "SmartAppSingle.h"
#include "light.h"
#include "MIUN.LoRa.h"
#include "MTSLog.h"
#include "mDot.h"
#include <sstream>

Light::Light():rgbPower(PB_0),luminPower(PA_5)
{
}

void Light::execute()
{
    uint16_t rgb[3];
    readRGB(rgb);
    logInfo("R:%d,G:%d,B:%d",rgb[0],rgb[1],rgb[2]);

    uint32_t lumin =  readLumin();
    logInfo("Lumin:%d",lumin);
        
    uint16_t solarCurrent = readSolarCurrent();
    logInfo("solar current: %d",solarCurrent);
    
    send(rgb[0],rgb[1],rgb[2],lumin, solarCurrent);
}

void Light::test()
{

}

void Light::readRGB(uint16_t rgb[])
{
    luminPower = 1;
    rgbPower = 1; 
    
    wait(1);
    ISL29125 RGB_sensor(I2C_SDA,I2C_SCL);
    wait(1);
    
    RGB_sensor.RGBmode(ISL29125_RGB);
    RGB_sensor.Range(ISL29125_10KLX);
    RGB_sensor.Resolution(ISL29125_16BIT);
    while(RGB_sensor.Read(ISL29125_RGB, rgb)!=true){}
    
    luminPower = 0; 
    rgbPower = 0;
}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     

uint32_t Light::readLumin()
{

    luminPower = 1;
    
    wait(1);
    TSL2561 tsl2561(I2C_SDA,I2C_SCL);
    tsl2561.setGain(TSL2561_GAIN_16X);      
    tsl2561.setTiming(TSL2561_INTEGRATIONTIME_101MS);  
    
    uint32_t value = tsl2561.getLuminosity (TSL2561_FULLSPECTRUM);
    
    luminPower = 0;
    
    return value;
}                                                                              


uint16_t Light::readSolarCurrent()
{
    luminPower = 1;
    
    wait(1);
    INA219 ina219 (I2C_SDA,I2C_SCL);
    uint16_t result = ina219.read_current_raw();
    
    luminPower = 0;
    
    return result;
}

void Light::send(uint16_t r,uint16_t g,uint16_t b, uint32_t lumin, uint16_t solarCurrent)
{
    stringstream sendStream;
    sendStream<<r<<","<<g<<","<<b<<","<<lumin<<","<<solarCurrent;
    string sendString =sendStream.str();
    logInfo("Send String: %s",sendString.c_str());
    sendReceive(sendString,1,NULL);
}