#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(A0,A1,A2,A3,A4,A5,TextLCD::LCD16x2);
AnalogIn entrada(PC_3);//pin entrada analogica
DigitalOut led (LED1);
int voltaje;
int entero, decimal;
double volt_in;

BusOut display(PA_10,PB_3,PB_5,PB_4,PB_10,PA_8,PA_9);//pines en la placa
BusOut Trans(PB_13,PB_14); //pin para los transistores, entrada Volt7seg
DigitalOut Indecimal (PC_7);//punto decimal
void ver();
void incre();
int decimas;
int conteo;
const char seg[10]= {0x40,0x79,0xA4,0xB0,0x99,0x92,0x82,0xF8,0x80,0x90};
Ticker visualizar;
Ticker incrementar;


void ver()
{
    switch(conteo) {
        case 0:
            display =0x00;
            Trans =0;
            break;
        case 1:
            display = seg[decimas];
            Trans=1;
            break;
        case 2:
            display =0x00;
            Trans =0;
            break;
        case 3:
            display = seg[entero];
            Trans=2;
            break;
    }
    conteo++;
    if(conteo==4) {
        conteo=0;
    }
}



void incre()
{

            volt_in= entrada.read();
        volt_in = volt_in*3300;
        voltaje = int(volt_in);
        entero = voltaje/1000;
        decimal = voltaje%1000;
        decimas = decimal/100;
}



int main()
{
    //lcd.cls();
    //lcd.printf("Su Voltaje es:");
    visualizar.attach(&ver,5.5e-3);
    incrementar.attach(&incre,1);



    while(1) {
        volt_in= entrada.read();
        volt_in = volt_in*3300;
        voltaje = int(volt_in);
        entero = voltaje/1000;
        decimal = voltaje%1000;
        led=1;
        lcd.cls();
        lcd.printf("El Voltaje es:");
        lcd.locate(1,5);
        lcd.printf("%01d,%03d volts", entero,decimal);//de la parte enteraimprime 1 digito y decima imprime 3
        wait_us(1e6);
        led=1;

    }
}