/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "LM75A.h"
#include "ADXL345.h"
#include "TextLCD.h"


Serial pc(USBTX, USBRX);


DigitalOut led1(LED1);
char buffer[6];   //creamos  buffer
int grados=0;
ADXL345 accelerometer(D11, D12, D13, D10);   // mosi, miso,sck,cs
LM75A temperatura(D14,D15,0x90);        // SDA, SCL, ADDRESS
I2C i2c_lcd(D3,D6); // SDA, SCL


TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2, TextLCD::HD44780); // I2C bus, PCF8574 addr, LCD Type, Ctrl Type



int main()
{
    temperatura.write_reg(0x01, 0x00); //Escribir el registro de la direccion para obetener los datos de la temperatura
    
    //////////////////////
    
    int readings[] ={0,0,0};  // crea el vector de lectura en 3 posiciones
    
    //pc.printf("Starting test...\n");                            
   

    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);

    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);   //activar  la maxima capacidad de resolucion
    
    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);  //activa la velocidad de testeo

    //Measurement mode.
    accelerometer.setPowerControl(0x08);        //activa modo de medicion
    
    ////////////////////
    
        
        
    while (true) {
      lcd.cls();
      
        grados=temperatura.read_T();  //llamar de temperatura la lectura de read_T
        pc.baud(9600);   // velocidad de comunicacion 
        //pc.printf("la temperatura es: %d grados celcius\n\r",grados); 
        //pc.printf("' ',%d,' '",grados); 
        led1 = !led1; 
        
        /////////////
        
        accelerometer.getOutput(readings);
        
        //13-bit, sign extended values.
        ///pc.printf("Aceleracion en x: %i, En Y: %i, En Z: %i\n\r", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);
        //pc.printf("' ',%i\n\r,' '",x);
        //pc.printf("' ',%i\n\r,' '",y);
        //pc.printf("' ',%i\n\r,' '",z);
        ///////////
        
        lcd.setBacklight(TextLCD::LightOn);// activa el led de la lCD   
        int x=(int16_t)readings[0];         //tomamos los valores de cada eje como un entero
        int y=(int16_t)readings[1];
        int z=(int16_t)readings[2];
        
        //pc.printf("' ',%i,' '",x);
        //pc.printf("' ',%i,' '",y);
        //pc.printf("' ',%i,' '",z);
        ///////////////////////
        
       sprintf(buffer,"' ',%d,%d,%d,%d,' '\n\r",grados,x,y,z);
       pc.write(buffer, strlen(buffer)); ///determina el tamaño de la funcióna imprimir
        
        ////////////
        lcd.locate(0,1);     
        lcd.printf("Y:%i,Z:%i \n", y,z);
        lcd.locate(0,0);
        lcd.printf("temp:%dC x:%i\n",grados,x);
        
        wait(1);
                
    }
    
}

