#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

Serial pc(USBTX, USBRX); // tx, rx

int main()
{
    char send[256];
    char recv[256];
    int i = 0;
 
    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0xAB}; 
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
 
    Websocket ws("ws://192.168.0.2:8888/ws");
    ws.connect();

    memset(send, 0, 256);
    memset(recv, 0, 256);
 
    while (1)
    {
        if (ws.read(recv))
        {
            pc.printf("%s\r\n", recv);
        }
        
        if(pc.readable())
        {
            send[i] = pc.getc();
            if (send[i] == 0x0d)
            {
                send[i] = 0x00;
                i = 0;
                ws.send(send);
                memset(send, 0, 256);
            }
            else if (send[i] == 0x08)
            {
                i--;
            }
            else if ((send[i] < 0x20) || (send[i] >= 0x7F))
            {
            }
            else
            {
                i++;
            }
        }
    }
}
