/*
 *  2016 Marco Valli
 *  based on the great job done by Gabriel Bianconi for Arduino Nunchuk 
 *  New initialization compatible with 3rd party controllers
 *
 */

#ifndef NUNCHUK_H
#define NUNCHUK_H

#include "mbed.h"

/*Example code:
#include "mbed.h"
#include "nunchuk.h"
Nunchuk mydevice;

int main (){
    mydevice.Init();
      
    while(1){
          mydevice.Update();
          printf("JX= %d JY= %d", mydevice.analogX, mydevice.analogY);
          printf("  -  AX= %d AY= %d AZ= %d", mydevice.accelX, mydevice.accelY, mydevice.accelZ);
          printf("  -  C= %d Z= %d", mydevice.buttonC, mydevice.buttonZ);
          printf("  -  Roll= %d\n", mydevice.roll);
          wait(1.0);
    }
 
}      */

class Nunchuk
{
  public:
    int analogX;
    int analogY;
    int accelX;
    int accelY;
    int accelZ;
    bool buttonZ;
    bool buttonC;
    signed char roll;  //-1    0   +1

    void Init();
    void Update();

  private:
    static const int ADDRESS=0xA4;
};


#endif