/*-----( Import needed libraries )-----*/  
#include "mbed.h"
#include <Adafruit_GFX.h>
#include <TFT_ILI9163C.h>

/* to connect Arduino TFT LCD Screen follow as described in
https://www.arduino.cc/en/Guide/TFTtoBoards
*/

/* define pin used*/
#define __MOSI D11
#define __MISO NC
#define __SCLK D13
#define __CS D10
#define __DC D9
#define __RST D8

/*-----( Declare Constants )-----*/ 
// Color definitions
#define BLACK           0x0000
#define BLUE            0x001F
#define RED             0xF800
#define GREEN           0x07E0
#define CYAN            0x07FF
#define MAGENTA         0xF81F
#define YELLOW          0xFFE0
#define WHITE           0xFFFF
#define TRANSPARENT     -1

#define SPI_BITRATE     50000000L

/*-----( Declare objects )-----*/ 
TFT_ILI9163C tft(__MOSI, __MISO, __SCLK, __CS, __DC, __RST);


int main()
{ 
    tft.begin();
    tft.setBitrate(50000000);
    
    for(int i= 0; i<3; i++){
        tft.setRotation(0);
        tft.fillScreen(RED);
        wait(1.0);
        tft.fillScreen(BLUE);
        wait(1.0);
        tft.fillScreen(GREEN);
        wait(1.0);
        tft.fillScreen(CYAN);
        wait(1.0);
        tft.fillScreen(MAGENTA);
        wait(1.0);
        }
        
    for(int i= 0; i<10; i++){       
        tft.fillRect(0,0,128,80, GREEN);
        tft.fillRect(0,80,128,160, YELLOW);
        wait(0.5);
        tft.fillRect(0,0,128,80, YELLOW);
        tft.fillRect(0,80,128,160, GREEN);
        wait(0.5);
        } 
        
    tft.fillScreen(BLACK);   
    tft.fillRect(20,60,60,80,CYAN);
 
        
        
}