// Include the standard types
#include "Shifter.h"

#define LOW 0
#define HIGH 1
DigitalOut SER_Pin(D4);         //pin 14 su 595
DigitalOut RCLK_Pin(D3);        //pin 11 su 595
DigitalOut SRCLK_Pin(D2);       //pin 12 su 595
int Number_of_Registers=2;

void Shifter::write()
{
//Set and display registers
//Only call AFTER all values are set how you would like (slow otherwise)
    RCLK_Pin.write(LOW);
    SRCLK_Pin.write(LOW);
    wait_us(10);
    //iterate through the registers
    for(int i = Number_of_Registers - 1; i >=  0; i--) {
        //iterate through the bits in each registers
        for(int j = 8 - 1; j >=  0; j--) {
            SRCLK_Pin.write(LOW);
            wait_us(4);
            int val = shiftRegisters[i] & (1 << j);
            SER_Pin.write(val);
            wait_us(1);           //wait_us(10);
            SRCLK_Pin.write(HIGH);
            wait_us(10);           //wait_us(10);
            SRCLK_Pin.write(LOW);
            wait_us(6);           //wait_us(10);
        }
    }  
    RCLK_Pin.write(HIGH);
    wait_us(10);
    RCLK_Pin.write(LOW);
    wait_us(10);
}

void Shifter::setPin(int index, bool val)
{
    int byteIndex = index/8;
    int bitIndex = index % 8;
    char current = shiftRegisters[byteIndex];
    current &= ~(1 << bitIndex); //clear the bit
    current |= val << bitIndex; //set the bit
    shiftRegisters[byteIndex] = current; //set the value
}

void Shifter::setAll(bool val)
{
//set all register pins to val
    for(int i = Number_of_Registers * 8 - 1; i >=  0; i--) {
        setPin(i, val);
    }
}

void Shifter::clear()
{
//set all register pins to LOW
    for(int i = Number_of_Registers * 8 - 1; i >=  0; i--) {
        setPin(i, HIGH);
    }
}