#include "mbed.h"
#include "TS_DISCO_F469NI.h"
#include "LCD_DISCO_F469NI.h"
#include "MAX31865.h"

#include "functions.h"
#include "display.h"
#include "colors.c"
#include "Output.h"

extern void clean(int, float, float);
extern void roast(int, int);
extern void stop(bool);

bool stato_porta=0;             //da cancellare, solo per prova porta

int main()
{
    setup_griglia();            //setup, parte grafica

    while(1) {
        getData();
        temperature_update();
//acquisisco la pressione sullo schermo per attivare i vari oggetti
        ts.GetState(&TS_State);
//------------------------------------------------------------------------------
///solo per prova, comandi vari
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=230 && TS_State.touchX[0]<300 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<90))    {
            Lampadina.stato=!Lampadina.stato;
            object_update();
        }
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=300 && TS_State.touchX[0]<370 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<90))    {
            Resistenza1.stato=!Resistenza1.stato;
            object_update();
        }
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=370 && TS_State.touchX[0]<440 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<90))    {
            Resistenza2.stato=!Resistenza2.stato;
            object_update();
        }
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=440 && TS_State.touchX[0]<510 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<90))    {
            Giracaffe.stato=!Giracaffe.stato;
            object_update();
        }
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=230 && TS_State.touchX[0]<300 && TS_State.touchY[0]>=90 && TS_State.touchY[0]<160))   {
            Bloccoporta.stato=!Bloccoporta.stato;
            (Bloccoporta.stato==1) ? Chiudo_porta() : Apro_porta();
        }
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=300 && TS_State.touchX[0]<370 && TS_State.touchY[0]>=90 && TS_State.touchY[0]<160))   {
            VTangenziale.stato=!VTangenziale.stato;
            object_update();
        }
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=370 && TS_State.touchX[0]<440 && TS_State.touchY[0]>=90 && TS_State.touchY[0]<160))   {
            VRadiale.stato=!VRadiale.stato;
            object_update();
        }
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=440 && TS_State.touchX[0]<510 && TS_State.touchY[0]>=90 && TS_State.touchY[0]<160))   {
            Ventola.stato=!Ventola.stato;
            object_update();
        }

        ///------ Apertura e chiusura scarico caffè
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=620 && TS_State.touchX[0]<690 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<90))    {
            Apro_scarico();
        }
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=620 && TS_State.touchX[0]<690 && TS_State.touchY[0]>=100 && TS_State.touchY[0]<170))  {
            Chiudo_scarico();
        }
        ///------
//------------------------------------------------------------------------------
//if ROAST pressed
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=290 && TS_State.touchY[0]<410))   {
            roast(temperatura_roast,tempo_roast);
        }
//if CLEAN pressed
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=165 && TS_State.touchY[0]<285))   {
            clean(clean_time, setpointLOW, setpointHIGH);
        }
//if STOP pressed
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<140))    {
            stop(0);
        }
//------------------------------------------------------------------------------
//if TEMPERATURA UPPER pressed
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=200 && TS_State.touchX[0]<260 && TS_State.touchY[0]>=270 && TS_State.touchY[0]<330))  {
            temperatura_roast = temperatura_roast+5;
            if (temperatura_roast >300) temperatura_roast =300;
        }
//if TEMPERATURA LOWER pressed
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=200 && TS_State.touchX[0]<260 && TS_State.touchY[0]>=350 && TS_State.touchY[0]<410))  {
            temperatura_roast = temperatura_roast-5;
            if (temperatura_roast <60) temperatura_roast =60;
        }
//if TEMPO UPPER pressed
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=325 && TS_State.touchX[0]<385 && TS_State.touchY[0]>=270 && TS_State.touchY[0]<330))  {
            tempo_roast = tempo_roast+15;
            if (tempo_roast >3000) tempo_roast =3000;
        }
//if TEMPO LOWER pressed
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=325 && TS_State.touchX[0]<385 && TS_State.touchY[0]>=350 && TS_State.touchY[0]<410))  {
            tempo_roast = tempo_roast-15;
            if (tempo_roast <120) tempo_roast =120;
        }
//------------------------------------------------------------------------------
//scrivo minuti e secondi
        int minuti = tempo_roast/60;
        int secondi = tempo_roast%60;
        sprintf((char*)text, "%2d", minuti);
        lcd.DisplayStringAt(295,LINE(8), (uint8_t *)&text, LEFT_MODE);
        sprintf((char*)text, "%2d", secondi);
        lcd.DisplayStringAt(350,LINE(8), (uint8_t *)&text, LEFT_MODE);
//scrivo temperatura
        sprintf((char*)text, "%3d", temperatura_roast);
        lcd.DisplayStringAt(295,LINE(10), (uint8_t *)&text, LEFT_MODE);
//------------------------------------------------------------------------------
        //per sicurezza, se accendo la macchina e la temperatura è superiore a 
        //quella di safe (150) attivo la ventola tangenziale fino a quando la 
        //temperatura non scende sotto quella di sicurezza
        if (PT1.temperature( )>temp_safe || PT2.temperature( )>temp_safe) {
            VTangenziale_acceso();
            temperature_update();
            wait(0.4);
        }
        wait(0.1);
    }
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//-----CLEAN--------------------------------------------------------------------
void clean(int clean_time, float setpointLOW, float setpointHIGH)
{
    Timer timer;
    timer.start();
    int previous_time, actual_time;
    Lampadina_spento();
    Ventola_spento();
    VRadiale_spento();
    VTangenziale_spento();
    Giracaffe_spento();
    Resistenza1_spento();
    Resistenza2_spento();
//-------------------------
//non procedo fino a quando la porta non è chiusa e anche il tappo del caffè
    /*   do {
           ts.GetState(&TS_State);
           if ((TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<140)) {                //STOP
               goto STOP_C;
           }
           wait(0.5);
       } while ( Chiudo_porta() );
    */
    do {
        ts.GetState(&TS_State);
        if ((TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<140)) {                //STOP
            goto STOP_C;
        }
        wait(0.5);
    } while ( tappo_caffe() );
//-------------------------
    //Chiudo_scarico();                                                         //chiudo lo scarico del caffè
    disegna_pulsanti(CLEAN_ATTIVO);
    VTangenziale_acceso();
    //VRadiale_acceso();
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"CLEAN ACTIVE             ", LEFT_MODE);
    previous_time = timer.read();
    while(clean_time>0) {
        //acquisisco la pressione sullo schermo per vedere se devo stoppare il ciclo mentre faccio il clean
        ts.GetState(&TS_State);
        if ((TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<140)) {                //STOP
            goto STOP_C;
        }

        //countdown dal clean_time a zero
        actual_time = timer.read();
        if (actual_time-previous_time >=1) {
            lcd.SetTextColor(black);
            sprintf((char*)text, "%5d", clean_time);
            lcd.DisplayStringAt(210,LINE(18), (uint8_t *)&text, LEFT_MODE);
            previous_time = actual_time;
            clean_time--;

            getData();
            temperature_update();
            //se la temperatura è sotto il setpoint high continuo a riscaldare, se la temperatura scende sotto il setpoint low ricomincio a riscaldare
            if (PT1.temperature( )<=setpointLOW)  {
                Resistenza1_acceso();
                Resistenza2_acceso();
            }
            if (PT1.temperature( )>setpointHIGH)  {
                Resistenza1_spento();
                Resistenza2_spento();
            }
        }
    }
//-------------------------
    //avvio la procedura di stop, se il tempo di clean è finito oppure ho premuto STOP
STOP_C:
    disegna_pulsanti(CLEAN_FINITO);
    stop(0);
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//-----STOP---------------------------------------------------------------------
void stop(bool clean_roast)
{
    //stop(0) se era in esecuzione il cleaning
    //stop(1) se era in esecuzione il roasting
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"STOP IN PROCESS          ", LEFT_MODE);
    lcd.DisplayStringAt(260,LINE(18), (uint8_t *)"      ", LEFT_MODE);
    //spengo le resistenze
    Resistenza1_spento();
    Resistenza2_spento();
    getData();
    temperature_update();
    lcd.SetTextColor(black);
    wait (2.0);

    VRadiale_spento();
    if (clean_roast) {
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"solo con roasting        ", LEFT_MODE);
        Ventola_acceso();
        Apro_scarico();
        Giracaffe_acceso();
        for (int i=60; i>0; i--) {                                              //tempo di raffreddamento caffè, da variare alla necessità
            wait(1);
            temperature_update();
        }
        Giracaffe_spento();
        Chiudo_scarico();
        for (int i=60; i>0; i--) {                                              //tempo di raffreddamento caffè, da variare alla necessità
            wait(1);
            temperature_update();
        }
        Ventola_spento();
    }
    //lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"tempe magg o minore 150  ", LEFT_MODE);
    if (PT1.temperature( )>temp_safe || PT2.temperature( )>temp_safe) {
        do {
            getData();
            lcd.SetTextColor(red);
            lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"TEMPERATURE   ABOVE   150", LEFT_MODE);
            wait (1.5);
            lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"NOT POSSIBLE TO OPEN DOOR", LEFT_MODE);
            wait (1.5);
            lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                         ", LEFT_MODE);
            getData();
            temperature_update();
            wait (1.5);
        } while (PT1.temperature( )>temp_safe);
    }
    //Apro_porta();
    Lampadina_spento();
    VTangenziale_spento();
    step_clean=0;
    step_roast=0;
    disegna_pulsanti(CLEAN);
    disegna_pulsanti(ROAST);
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                         ", LEFT_MODE);
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"STOP COMPLETED           ", LEFT_MODE);
    ts.GetState(&TS_State);
    wait (2);
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                         ", LEFT_MODE);
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//-----ROAST--------------------------------------------------------------------
void roast (int roast_temp, int roast_time)
{
    Timer timer;
    timer.start();
    int previous_time, actual_time;
    Lampadina_spento();
    Ventola_spento();
    VRadiale_spento();
    VTangenziale_spento();
    Giracaffe_spento();
    Resistenza1_spento();
    Resistenza2_spento();
    Chiudo_scarico();
//-------------------------
//non procedo fino a quando la porta non è chiusa e anche il tappo del caffè
    /*    do {
           ts.GetState(&TS_State);
           if ((TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<140)) {                //STOP
               goto STOP_R;
           }
           wait(0.5);
       } while ( Chiudo_porta() );
    */
    do {
        ts.GetState(&TS_State);
        if ((TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<140)) {                //STOP
            goto STOP_R;
        }
        wait(0.5);
    } while ( tappo_caffe() );
//-------------------------

//PRE ROAST
    disegna_pulsanti(ROAST_PRE);
    temperature_update();
    VRadiale_acceso();
    VTangenziale_acceso();
    Lampadina_acceso();
    while ( PT2.temperature()<=roast_temp && step_roast==0) {
        //if STOP pressed
        ts.GetState(&TS_State);
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<140))    {
            goto STOP_R;
        }
        Resistenza1_acceso();
        Resistenza2_acceso();
        getData();
        temperature_update();
    }
    Resistenza2_spento();
    step_roast=1;

//APRI E CHIUDI IL TAPPO CAFFE e POI AVVII IL ROAST
    Giracaffe_acceso();
    do {
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"OPEN COFFE COVER         ", LEFT_MODE);
        //if STOP pressed
        ts.GetState(&TS_State);
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<140))    {
            goto STOP_R;
        }
        getData();
        temperature_update();
        if (PT2.temperature( )<=roast_temp)  {
            Resistenza1_acceso();
        }
        if (PT2.temperature( )>roast_temp)  {
            Resistenza1_spento();
        }
        wait(1.0);
    } while (myDataIn[0]==1 && step_roast==1);
    step_roast=2;

    do {
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"POOR COFFE, CLOSE COVER  ", LEFT_MODE);
        //if STOP pressed
        ts.GetState(&TS_State);
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<140))    {
            stop(1);
        }
        getData();
        temperature_update();
        if (PT2.temperature( )<=roast_temp)  {
            Resistenza1_acceso();
        }
        if (PT2.temperature( )>roast_temp)  {
            Resistenza1_spento();
        }
        wait(1.0);
    } while (myDataIn[0]==0 && step_roast==2);
    step_roast=3;
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                         ", LEFT_MODE);
    //lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"ades dovr avv roast      ", LEFT_MODE);
    wait(1.0);

//ROAST
    disegna_pulsanti(ROAST_ACTIVE);
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"ROASTING IN PROCESS      ", LEFT_MODE);
    timer.start();
    previous_time = timer.read();
    while ( roast_time>0 && step_roast==3) {
        //if STOP pressed
        ts.GetState(&TS_State);
        if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=20 && TS_State.touchX[0]<140 && TS_State.touchY[0]>=20 && TS_State.touchY[0]<140))    {
            goto STOP_R;
        }

        actual_time = timer.read();
        if (actual_time-previous_time >=1) {
            lcd.SetTextColor(black);
            sprintf((char*)text, "%5d", roast_time);
            lcd.DisplayStringAt(600,LINE(18), (uint8_t *)&text, LEFT_MODE);
            previous_time = actual_time;
            roast_time--;

            getData();
            temperature_update();
            if (PT2.temperature( )<=roast_temp)  {
                Resistenza1_acceso();
            }
            if (PT2.temperature( )>roast_temp)  {
                Resistenza1_spento();
            }
        }
    }
    //se ho completato il ciclo di preroasting e roasting e non ho premuto STOP
STOP_R:
    lcd.DisplayStringAt(600, LINE(18), (uint8_t *)"     ", LEFT_MODE);
    disegna_pulsanti(ROAST_FINITO);
    stop(1);
}

