#ifndef FUCTIONS_H
#define FUNCTIONS_H

#include "colors.c"
#include "mbed.h"
#include "Output.h"
#include "Shifter.h"
#include "LCD_DISCO_F469NI.h"
#include "display.h"

Serial pc(SERIAL_TX, SERIAL_RX);
//MAX31865_RTD( ptd_type type,PinName mosi, PinName miso, PinName sclk, PinName nss);
MAX31865_RTD PT1(MAX31865_RTD::RTD_PT100, D11, D12, D13, A0);
MAX31865_RTD PT2(MAX31865_RTD::RTD_PT100, D11, D12, D13, A1);
MAX31865_RTD PT3(MAX31865_RTD::RTD_PT100, D11, D12, D13, A2);

TS_DISCO_F469NI ts;
TS_StateTypeDef TS_State;
uint8_t status;
uint8_t cleared = 0;
uint8_t prev_nb_touches = 0;
uint8_t text[30];

int temp_safe=150;                                                              //temperatura di sicurezza per la  quale non è possibile aprire la porta (150)
int MAXtemp_safe=450;                                                           //temperatura di sicurezza per la  quale non è possibile aprire la porta (450)   
float setpointHIGH = 450;                                                       //setpoint temperatura high per il clean, temperatura per il cleaning
float setpointLOW = (setpointHIGH-20);                                          //setpoint temperatura low per il clean
int clean_time=1800;                                                            //tempo di clean, (1800)
int tempo_roast =1200;                                                          //tempo di roasting, posso variare con le frecce (1200)
int temperatura_roast = 200;                                                    //temperatura di roasting, posso variare con le frecce (200)
int step_clean=0;
int step_roast=0;


/// dichiarazione variabili ////////////////////////////////////////////////////
//per i sensori
static bool myDataIn[8] = {1,0,1,0,1,0,1,0};
//myDataIn[0]               tappo caffè chiuso;
//myDataIn[1]               sensore porta chiusa;
//myDataIn[2]               finecorsa sarico aperto;
//myDataIn[3]               finecorsa scarico chiuso;
//myDataIn[4];               //da dare un nome
//myDataIn[5];               //da dare un nome
//myDataIn[6];               //da dare un nome
//myDataIn[7];               //da dare un nome

//per i relay
Shifter scheda_8relay;                  //!! pinout defined in library
Output Bloccoporta;                     //
Output Giracaffe;                       // 24V, palette agita caffé
Output Lampadina;                       // Lampadina
Output VTangenziale;                    // 1
Output VRadiale;                        // 2
Output Scarico_caffe;                   // motore scarico caffé
Output Resistenza1;                     // Heater 1, centrale
Output Resistenza2;                     // Heater 2, più esterno
Output Ventola;                         // Cooling, 24V, ventola cassetto caffè

bool Activate_Door;                     //sul SSR per comandare il bloccoporta

extern bool Apro_porta();               //definita più in basso
bool Chiudo_scarico();                  //definita più in basso
/// funzioni ///////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
void object_update()
{
    //update delle immagini e dello stato delle uscite
    Lampadina.draw_image    (&_acLampadina_acceso[0], &_acLampadina_spento[0], Lampadina.stato, 230, 20);
    Resistenza1.draw_image  (&_acResistenza1_acceso[0], &_acResistenza1_spento[0], Resistenza1.stato, 300, 20);
    Resistenza2.draw_image  (&_acResistenza2_acceso[0], &_acResistenza2_spento[0], Resistenza2.stato, 370, 20);
    Giracaffe.draw_image    (&_acGiracaffe_acceso[0], &_acGiracaffe_spento[0], Giracaffe.stato, 440, 20);
    Bloccoporta.draw_image  (&_acPorta_aperto[0], &_acPorta_chiuso[0], Bloccoporta.stato, 230, 90);
    VTangenziale.draw_image (&_acVTangenziale_acceso[0], &_acVTangenziale_spento[0], VTangenziale.stato, 300, 90);
    VRadiale.draw_image     (&_acVRadiale_acceso[0], &_acVRadiale_spento[0], VRadiale.stato, 370, 90);
    Ventola.draw_image      (&_acVentola_acceso[0], &_acVentola_spento[0], Ventola.stato, 440, 90);
    //update uscita 74HC595
    bool array[16]= {!Lampadina.stato, !Giracaffe.stato, !VTangenziale.stato, !Resistenza1.stato, !Resistenza2.stato, !VRadiale.stato, !Scarico_caffe.ON_OFF, !Scarico_caffe.CW_CCW, !Ventola.stato, !Activate_Door,1,1,1,1,1,1};
    for (int i=0; i<16; i++) {
        scheda_8relay.setPin(i,array[i]);
        wait_us(2);
        scheda_8relay.write();
        //sprintf((char*)text, "%d ", array[i]);
        //lcd.DisplayStringAt(200+20*i, LINE( 7),(uint8_t *)&text, LEFT_MODE);
    }
}
//------------------------------------------------------------------------------
/// Lampadina
void Lampadina_acceso()
{
    Lampadina.stato=1;
    object_update();
}
void Lampadina_spento()
{
    Lampadina.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
bool setup_griglia()
{
    lcd.Clear(light_sky_blue);
    lcd.SetBackColor(light_sky_blue);
    lcd.SetFont(&Font24);
    lcd.SetTextColor(black);
    lcd.DisplayStringAt(670, LINE(0), (uint8_t *)"Ver 2.a", LEFT_MODE);
    Lampadina_acceso();
    wait(0.1);
    Lampadina_spento();
    wait(0.1);

    //update delle immagini e dello stato delle uscite
    Lampadina.draw_image    (&_acLampadina_acceso[0], &_acLampadina_spento[0], Lampadina.stato, 230, 20);
    Resistenza1.draw_image  (&_acResistenza1_acceso[0], &_acResistenza1_spento[0], Resistenza1.stato, 300, 20);
    Resistenza2.draw_image  (&_acResistenza2_acceso[0], &_acResistenza2_spento[0], Resistenza2.stato, 370, 20);
    Giracaffe.draw_image    (&_acGiracaffe_acceso[0], &_acGiracaffe_spento[0], Giracaffe.stato, 440, 20);
    Bloccoporta.draw_image  (&_acPorta_aperto[0], &_acPorta_chiuso[0], Bloccoporta.stato, 230, 90);
    VTangenziale.draw_image (&_acVTangenziale_acceso[0], &_acVTangenziale_spento[0], VTangenziale.stato, 300, 90);
    VRadiale.draw_image     (&_acVRadiale_acceso[0], &_acVRadiale_spento[0], VRadiale.stato, 370, 90);
    Ventola.draw_image      (&_acVentola_acceso[0], &_acVentola_spento[0], Ventola.stato, 440, 90);

    //disegno bottoni
    disegna_pulsanti(STOP);
    disegna_pulsanti(CLEAN);
    disegna_pulsanti(ROAST);
    disegna_pulsanti(PULSANTI);

    lcd.DisplayStringAt(200, LINE( 8),  (uint8_t *)"Time:", LEFT_MODE);
    lcd.DisplayStringAt(330, LINE(8), (uint8_t *)"'", LEFT_MODE);
    lcd.DisplayStringAt(385, LINE(8), (uint8_t *)"''", LEFT_MODE);
    lcd.DisplayStringAt(200, LINE( 10), (uint8_t *)"Temp:", LEFT_MODE);
    lcd.DrawCircle(355, LINE(10)+3, 4);
    lcd.DisplayStringAt(360, LINE( 10), (uint8_t *)"C", LEFT_MODE);
    lcd.DisplayStringAt(620, LINE( 9), (uint8_t *)"T1:", LEFT_MODE);
    lcd.DisplayStringAt(620, LINE(11), (uint8_t *)"T2:", LEFT_MODE);
    lcd.DisplayStringAt(620, LINE(13), (uint8_t *)"T3:", LEFT_MODE);

    //per prova, da togliere dopo
    lcd.SetTextColor(red);
    lcd.FillRect (620, 20, 70, 70);
    lcd.SetTextColor(green);
    lcd.FillRect (620, 100, 70, 70);
    lcd.SetTextColor(black);
    lcd.SetBackColor(red);
    lcd.DisplayStringAt(620, 40, (uint8_t *)"OPEN", LEFT_MODE);
    lcd.SetBackColor(green);
    lcd.DisplayStringAt(620, 120, (uint8_t *)"CLOS", LEFT_MODE);
    lcd.SetBackColor(light_sky_blue);
    //fino qui

    PT1.configure( true, true, false, false, MAX31865_FAULT_DETECTION_NONE,
                   true, true, 0x0000, 0x7fff );
    PT2.configure( true, true, false, false, MAX31865_FAULT_DETECTION_NONE,
                   true, true, 0x0000, 0x7fff );
    PT3.configure( true, true, false, false, MAX31865_FAULT_DETECTION_NONE,
                   true, true, 0x0000, 0x7fff );
    //Apro_porta();
    return 0;
}
//------------------------------------------------------------------------------
bool * getData()
{
    //define where your pins are
    DigitalOut latchPin(D7);
    DigitalOut clockPin(D6);
    DigitalIn  dataPin(D5);
    float tempoattesa = 20;
    //acquiring values
    latchPin.write(1);
    wait_us(tempoattesa);
    //read values acquired and store in array
    latchPin.write(0);
    for (int i=7; i>=0; i--) {
        wait_us(tempoattesa);
        clockPin.write(0);
        wait_us(tempoattesa);
        myDataIn[i] = dataPin.read();      //1 if OT open, 0 if OT close
        clockPin.write(1);
    }
    
    //per prova da togliere dopo
    for (int i=3; i>=0; i--) {  // D7,D6,.....,D1,D0
        sprintf((char*)text, "%d", myDataIn[0+i]);
        lcd.DisplayStringAt(580+20*i,LINE(8), (uint8_t *)&text, LEFT_MODE);
    }
    //
    
    return myDataIn;
}
//------------------------------------------------------------------------------
/// Resistenza 1
void Resistenza1_acceso()
{
    Resistenza1.stato=1;
    object_update();
}
void Resistenza1_spento()
{
    Resistenza1.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
/// Resistenza 2
void Resistenza2_acceso()
{
    Resistenza2.stato=1;
    object_update();
}
void Resistenza2_spento()
{
    Resistenza2.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
void temperature_update()
{
    lcd.DisplayStringAt(680, LINE( 9), (uint8_t *)"      ", LEFT_MODE);
    lcd.DisplayStringAt(680, LINE(11), (uint8_t *)"      ", LEFT_MODE);
    lcd.DisplayStringAt(680, LINE(13), (uint8_t *)"      ", LEFT_MODE);
    PT1.read_all( );
    if (PT1.temperature( )>150)  lcd.SetTextColor(red);
    else lcd.SetTextColor(black);
    sprintf((char*)text, "%1.0f", PT1.temperature( ));
    lcd.DisplayStringAt(680, LINE(9), (uint8_t *)&text, LEFT_MODE);
    PT2.read_all( );
    if (PT2.temperature( )>150)  lcd.SetTextColor(red);
    else lcd.SetTextColor(black);
    sprintf((char*)text, "%1.0f", PT2.temperature( ));
    lcd.DisplayStringAt(680, LINE(11), (uint8_t *)&text, LEFT_MODE);
    PT3.read_all( );
    if (PT3.temperature( )>150)  lcd.SetTextColor(red);
    else lcd.SetTextColor(black);
    sprintf((char*)text, "%1.0f", PT3.temperature( ));
    lcd.DisplayStringAt(680, LINE(13), (uint8_t *)&text, LEFT_MODE);
    lcd.SetTextColor(black);

    //per sicurezza la temperatura non può superare la MAX temperaratura di sicurezza (450 gradi)
    if (PT1.temperature( )>MAXtemp_safe || PT2.temperature( )>MAXtemp_safe) {
        Resistenza1_spento();
        Resistenza2_spento();
        wait(1.0);
    }
}
//------------------------------------------------------------------------------
/// Ventola 12/24 volt
void Ventola_acceso()
{
    Ventola.stato=1;
    object_update();
}
void Ventola_spento()
{
    Ventola.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
/// Ventola Radiale
void VRadiale_acceso()
{
    VRadiale.stato=1;
    object_update();
}
void VRadiale_spento()
{
    VRadiale.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
/// Ventola Tangenziale
void VTangenziale_acceso()
{
    VTangenziale.stato=1;
    object_update();
}
void VTangenziale_spento()
{
    VTangenziale.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
/// Giracaffe
void Giracaffe_acceso()
{
    Giracaffe.stato=1;
    object_update();
}
void Giracaffe_spento()
{
    Giracaffe.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
///Apro scarico caffe
bool Apro_scarico()
{
    getData();
    while(!myDataIn[2]) {
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"COFFE UNLOAD IS OPENING  ", LEFT_MODE);
        Scarico_caffe.CW_CCW=1;
        wait(0.1);
        Scarico_caffe.ON_OFF=1;
        temperature_update();
        object_update();
        wait(0.012);
        getData();
    }
    Scarico_caffe.ON_OFF=0;
    object_update();
    wait(0.012);
    getData();
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                             ", LEFT_MODE);
    wait(0.1);
    return 0;
}
///Chiudo scarico caffe
bool Chiudo_scarico()
{
    getData();
    while(!myDataIn[3]) {
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"COFFE UNLOAD IS CLOSING  ", LEFT_MODE);
        Scarico_caffe.CW_CCW=0;
        wait(0.1);
        Scarico_caffe.ON_OFF=1;
        temperature_update();
        object_update();
        wait(0.012);
        getData();
    }
    Scarico_caffe.ON_OFF=0;
    object_update();
    wait(0.012);
    getData();
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                             ", LEFT_MODE);
    wait(0.1);
    return 0;
}
//------------------------------------------------------------------------------
///Porta
bool Apro_porta()
{
/*
    int time_door=5;
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"WAIT TO OPEN DOOR        ", LEFT_MODE);
    while(time_door>0) {
        sprintf((char*)text, "%5d", time_door);
        lcd.DisplayStringAt(600,LINE(18), (uint8_t *)&text, LEFT_MODE);
        time_door--;
        temperature_update();
        wait(1);
    }
    //attivazione del relay per aprire la porta
    for (int i=0; i<2; i++) {
        Activate_Door=1;
        object_update();
        //wait_us(20);
        wait(0.02);
        Activate_Door=0;
        object_update();
        wait(4);
        //wait_us(20);
    }
    ///
    lcd.DisplayStringAt(600, LINE(18), (uint8_t *)"     ", LEFT_MODE);
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"DOOR IS OPEN             ", LEFT_MODE);
    wait(1.0);
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                         ", LEFT_MODE);
    Bloccoporta.stato=0;
    object_update();
*/
    return 0;
}
bool Chiudo_porta()
{
/*
    int time_door=5;
    bool stato_porta;
    getData();
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"WAIT TO CLOSE DOOR       ", LEFT_MODE);
    while(time_door>0) {
        sprintf((char*)text, "%5d", time_door);
        lcd.DisplayStringAt(600,LINE(18), (uint8_t *)&text, LEFT_MODE);
        time_door--;
        temperature_update();
        wait(1);
    }
    lcd.DisplayStringAt(600, LINE(18), (uint8_t *)"     ", LEFT_MODE);
//attivazione del relay per chiudere la porta
    if (!myDataIn[1]) {
        for (int i=0; i<1; i++) {
            Activate_Door=1;
            object_update();
            wait(0.02);
            //wait_us(20);
            Activate_Door=0;
            object_update();
            wait(0.05);
            //wait_us(20);
        }
        ///
        Bloccoporta.stato=1;
        object_update();
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"DOOR IS CLOSED           ", LEFT_MODE);
        stato_porta=0;
        wait(2.0);
    } else {
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"CLOSE THE  DOOR PLEASE   ", LEFT_MODE);
        stato_porta=1;
    }
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                         ", LEFT_MODE);  
    return stato_porta;
    */
    return 0;
}
//------------------------------------------------------------------------------
///Tappo caffè
bool tappo_caffe()
{
    bool stato_tappo_caffe;
    getData();
    if (myDataIn[0]) {
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"COFFE COVER IS CLOSED    ", LEFT_MODE);
        stato_tappo_caffe=0;
    } else {
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"CLOSE COFFE COVER PLEASE ", LEFT_MODE);
        stato_tappo_caffe=1;
    }
    wait(1.0);
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                         ", LEFT_MODE);
    return stato_tappo_caffe;
}
//End of Functions//
#endif
