#ifndef DISPLAY_H
#define DISPLAY_H

#include "colors.c"
#include "mbed.h"
#include "LCD_DISCO_F469NI.h"

#include "AClean_0.c"
#include "AClean_1.c"
#include "AClean_2.c"
#include "ARoast_0.c"
#include "ARoast_1.c"
#include "ARoast_2.c"
#include "ARoast_3.c"
#include "APower.c"
#include "APulsanti.c"
#include "Porta_aperto.c"
#include "Porta_chiuso.c"
#include "Giracaffe_acceso.c"
#include "Giracaffe_spento.c"
#include "Lampadina_acceso.c"
#include "Lampadina_spento.c"
#include "VTangenziale_acceso.c"
#include "VTangenziale_spento.c"
#include "VRadiale_acceso.c"
#include "VRadiale_spento.c"
#include "Resistenza1_acceso.c"
#include "Resistenza1_spento.c"
#include "Resistenza2_acceso.c"
#include "Resistenza2_spento.c"
#include "Ventola_acceso.c"
#include "Ventola_spento.c"


LCD_DISCO_F469NI lcd;
/*
TS_DISCO_F469NI ts;
TS_StateTypeDef TS_State;
//uint16_t X, Y;
uint8_t status;
uint8_t cleared = 0;
uint8_t prev_nb_touches = 0;
uint8_t text[30];
*/

enum {STOP, CLEAN, ROAST, PULSANTI, CLEAN_ATTIVO, ROAST_PRE, ROAST_ACTIVE, CLEAN_FINITO, ROAST_FINITO};
//sono le icone dei pulsanti power, clean, roast nei loro vari stati
void disegna_pulsanti(int pulsante)
{
    int riga, colonna, contatore=0;
    switch (pulsante) {
        case 0:                                                                 //STOP
            contatore=0;
            for (riga=0; riga<120; riga++)  {
                for ( colonna=0; colonna<120; colonna++)  {
                    lcd.DrawPixel (20+colonna, 20+ riga, _acAPower[contatore]);
                    contatore++;
                }
                colonna=0;
            }
            //lcd.DrawRect (20, 20, 120, 120);
            break;
        case 1:                                                                 //CLEAN
            contatore=0;
            for (riga=0; riga<120; riga++)  {
                for ( colonna=0; colonna<120; colonna++)  {
                    lcd.DrawPixel (20+colonna, 165+ riga, _acAClean_0[contatore]);
                    contatore++;
                }
                colonna=0;
            }
            //lcd.DrawRect (20, 165, 120, 120);
            break;
        case 2:                                                                 //ROAST
            contatore=0;
            for (riga=0; riga<120; riga++)  {
                for ( colonna=0; colonna<120; colonna++)  {
                    lcd.DrawPixel (20+colonna, 290+ riga, _acARoast_0[contatore]);
                    contatore++;
                }
                colonna=0;
            }
            //lcd.DrawRect (20, 290, 120, 120);
            break;
        case 3:                                                                 //pulsanti regolazione tempo e temperatura
            for (riga=0; riga<140; riga++)  {
                for ( colonna=0; colonna<200; colonna++)  {
                    lcd.DrawPixel (180+colonna, 270+ riga, _acAPulsanti[contatore]);
                    contatore++;
                }
                colonna=0;
            }
            break;
        case 4:                                                                 //CLEAN ATTIVO
            contatore=0;
            for (riga=0; riga<120; riga++)  {
                for ( colonna=0; colonna<120; colonna++)  {
                    lcd.DrawPixel (20+colonna, 165+ riga, _acAClean_1[contatore]);
                    contatore++;
                }
                colonna=0;
            }
            //lcd.DrawRect (20, 165, 120, 120);
            break;
        case 5:                                                                 //ROAST PRE
            contatore=0;
            for (riga=0; riga<120; riga++)  {
                for ( colonna=0; colonna<120; colonna++)  {
                    lcd.DrawPixel (20+colonna, 290+ riga, _acARoast_1[contatore]);
                    contatore++;
                }
                colonna=0;
            }
            //lcd.DrawRect (20, 290, 120, 120);
            break;
        case 6:                                                                 //ROAST ACTIVE
            contatore=0;
            for (riga=0; riga<120; riga++)  {
                for ( colonna=0; colonna<120; colonna++)  {
                    lcd.DrawPixel (20+colonna, 290+ riga, _acARoast_2[contatore]);
                    contatore++;
                }
                colonna=0;
            }
            //lcd.DrawRect (20, 290, 120, 120);
            break;
        case 7:                                                                 //CLEAN FINITO
            contatore=0;
            for (riga=0; riga<120; riga++)  {
                for ( colonna=0; colonna<120; colonna++)  {
                    lcd.DrawPixel (20+colonna, 165+ riga, _acAClean_2[contatore]);
                    contatore++;
                }
                colonna=0;
            }
            //lcd.DrawRect (20, 165, 120, 120);
            break;
        case 8:                                                                 //ROAST FINITO
            contatore=0;
            for (riga=0; riga<120; riga++)  {
                for ( colonna=0; colonna<120; colonna++)  {
                    lcd.DrawPixel (20+colonna, 290+ riga, _acARoast_3[contatore]);
                    contatore++;
                }
                colonna=0;
            }
            //lcd.DrawRect (20, 165, 120, 120);
            break;
    }
}
//------------------------------------------------------------------------------

#endif