#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

#include "Bloccoporta_acceso.c"
#include "Bloccoporta_spento.c"
#include "Girarrosto_acceso.c"
#include "Girarrosto_spento.c"
#include "Lampadina_acceso.c"
#include "Lampadina_spento.c"
#include "Motore_acceso.c"
#include "Motore_spento.c"
#include "Resistenza1_acceso.c"
#include "Resistenza1_spento.c"
#include "Resistenza2_acceso.c"
#include "Resistenza2_spento.c"
#include "Ventilatore1_acceso.c"
#include "Ventilatore1_spento.c"
#include "Ventilatore2_acceso.c"
#include "Ventilatore2_spento.c"

#include "Clean.c"
#include "Roast.c"
#include "Stop.c"

#include "functions.h"
#include "colors.c"
#include "Output.h"
#include "Shifter.h"

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

extern void clean(int);
extern void stop();
extern void object_update();

TS_StateTypeDef TS_State;
uint16_t X, Y;
uint8_t idx;
uint8_t status;
uint8_t cleared = 0;
uint8_t prev_nb_touches = 0;
int numerotappe=0;
uint8_t text[30];

Output Bloccoporta;
Output Girarrosto;
Output Lampadina;
Output Motore;
Output Resistenza1;
Output Resistenza2;
Output Ventilatore1;
Output Ventilatore2;

Shifter scheda_8relay;          //!! pinout defined in library
bool array[16]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

int main()
{
    setup_griglia();
    while(1) {
//acquisisco la pressione sullo schermo per attivare i vari oggetti
        ts.ResetTouchData(&TS_State);
        ts.GetState(&TS_State);
        X = TS_State.touchX[0];                             //acquisisco la X
        Y = TS_State.touchY[0];                             //acquisisco la Y
        /*
        if (X>=310 && X<360 && Y>=0 && Y<60)        {
            Lampadina.stato=!Lampadina.stato;
            array[0]=Lampadina.stato;
        }
        if (X>=310 && X<360 && Y>=60 && Y<120)  {
            Motore.stato=!Motore.stato;
            array[1]=Motore.stato;
        }
        if (X>=310 && X<360 && Y>=120 && Y<180) {
            Ventilatore1.stato=!Ventilatore1.stato;
            array[2]=Ventilatore1.stato;
        }
        if (X>=310 && X<360 && Y>=180 && Y<240) {
            Ventilatore2.stato=!Ventilatore2.stato;
            array[3]=Ventilatore2.stato;
        }
        if (X>=360 && X<410 && Y>=0 && Y<60)        {
            Bloccoporta.stato=!Bloccoporta.stato;
            array[4]=Bloccoporta.stato;
        }
        if (X>=360 && X<410 && Y>=60 && Y<120)  {
            Girarrosto.stato=!Girarrosto.stato;
            array[5]=Girarrosto.stato;
        }
        if (X>=360 && X<410 && Y>=120 && Y<180) {
            Resistenza1.stato=!Resistenza1.stato;
            array[6]=Resistenza1.stato;
        }
        if (X>=360 && X<410 && Y>=180 && Y<240) {
            Resistenza2.stato=!Resistenza2.stato;
            array[7]=Resistenza2.stato;
        }
        */
        if (X>=20 && X<120 && Y>=20 && Y<80) {      //ROAST

        }
        if (X>=20 && X<120 && Y>=90 && Y<150) {     //CLEAN
            clean(10000);
        }
        if (X>=20 && X<120 && Y>=160 && Y<220) {    //STOP

        }
        if (TS_State.touchDetected) wait(0.1);
        
        object_update();

        wait(0.1);
    }//close while(1)
}//close main

void clean(int clean_time)
{
    Timer timer;
    timer.start();
    int previous_time, actual_time;
    previous_time = timer.read();
    Lampadina.stato=1;
    Resistenza1.stato=1;
    Resistenza2.stato=1;

    while(1) {
        actual_time = timer.read();
        uint8_t text[30];
        //acquisisco la pressione sullo schermo per attivare i vari oggetti
        ts.ResetTouchData(&TS_State);
        ts.GetState(&TS_State);
        int X = TS_State.touchX[0];                             //acquisisco la X
        int Y = TS_State.touchY[0];                             //acquisisco la Y
        if (X>=20 && X<120 && Y>=160 && Y<220) {                //STOP
            stop();
            break;
        }
        //countdown dal clean_time a zero
        if (actual_time-previous_time >=1) {
            lcd.SetFont(&Font24);
            lcd.SetTextColor(black);
            sprintf((char*)text, "%5d", clean_time);
            lcd.DisplayStringAt(130,100, (uint8_t *)&text, LEFT_MODE);
            previous_time = actual_time;
            clean_time--;
        }
        //se il tempo di clean è finito porto gli output a zero e aggiorno, poi esco dal ciclo
        if (clean_time<0) {
            stop();
            break;
        }
        
        object_update();
    }
}
void stop()
{   
    //imposto gli output a zero, poi aggiorno
    Lampadina.stato=0;
    Resistenza1.stato=0;
    Resistenza2.stato=0;
    
    object_update();
}
void object_update()
{   //update delle immagini e dello stato delle uscite
    //disegno lo stato dei vari oggetti
    Lampadina.draw_image    (&_acLampadina_acceso[0], &_acLampadina_spento[0], Lampadina.stato, 310, 0);
    Motore.draw_image       (&_acMotore_acceso[0], &_acMotore_spento[0], Motore.stato, 310, 60);
    Ventilatore1.draw_image (&_acVentilatore1_acceso[0], &_acVentilatore1_spento[0], Ventilatore1.stato, 310, 120);
    Ventilatore2.draw_image (&_acVentilatore2_acceso[0], &_acVentilatore2_spento[0], Ventilatore2.stato, 310, 180);
    Bloccoporta.draw_image  (&_acBloccoporta_acceso[0], &_acBloccoporta_spento[0], Bloccoporta.stato, 360, 0);
    Girarrosto.draw_image   (&_acGirarrosto_acceso[0], &_acGirarrosto_spento[0], Girarrosto.stato, 360, 60);
    Resistenza1.draw_image  (&_acResistenza1_acceso[0], &_acResistenza1_spento[0], Resistenza1.stato, 360, 120);
    Resistenza2.draw_image  (&_acResistenza2_acceso[0], &_acResistenza2_spento[0], Resistenza2.stato, 360, 180);
    //update uscita 74HC595
    for (int i=0; i<16; i++) scheda_8relay.setPin(i,array[i]);
    scheda_8relay.write();
}