#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

#include "Bloccoporta_acceso.c"
#include "Bloccoporta_spento.c"
#include "Girarrosto_acceso.c"
#include "Girarrosto_spento.c"
#include "Lampadina_acceso.c"
#include "Lampadina_spento.c"
#include "Ventilatore_turbo_acceso.c"
#include "Ventilatore_turbo_spento.c"
#include "Resistenza1_acceso.c"
#include "Resistenza1_spento.c"
#include "Resistenza2_acceso.c"
#include "Resistenza2_spento.c"
#include "Cooling_acceso.c"
#include "Cooling_spento.c"
#include "Ventilatore2_acceso.c"
#include "Ventilatore2_spento.c"

#include "Clean.c"
#include "Roast.c"
#include "Stop.c"

#include "functions.h"
#include "colors.c"
#include "Output.h"
#include "Shifter.h"

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

extern void clean(int, float, float);
extern void roast(int, int);
extern void stop();
extern void sportello_scarico(bool);
extern void object_update();

TS_StateTypeDef TS_State;
uint16_t X, Y;
uint8_t idx;
uint8_t status;
uint8_t cleared = 0;
uint8_t prev_nb_touches = 0;
int numerotappe=0;
uint8_t text[30];

Output Bloccoporta;             //
Output Girarrosto;              // palette agita caffé
Output Lampadina;               //
Output Ventilatore_turbo;       // ventilatore turbo
Output Scarico_caffe;           // motore scarico caffé
Output Resistenza1;             //
Output Resistenza2;             //
Output Cooling;                 // cooling
Output Ventilatore2;            // cassetto

AnalogIn Temperatura_forno(A0);
AnalogIn Temperatura_sonda1(A1);        //da dare un nome
AnalogIn Temperatura_sonda2(A2);        //da dare un nome
AnalogIn Temperatura_sonda3(A3);        //da dare un nome
AnalogIn Temperatura_sonda4(A4);        //da dare un nome
AnalogIn Temperatura_sonda5(A5);        //da dare un nome

CD74HC165E Sensore(D12, D10, D9);  //(PinName PL, PinName CP, PinName Q7);
bool* sensori;
bool switch1=sensori[0];                //da dare un nome
bool switch2=sensori[1];                //da dare un nome
bool switch3=sensori[2];                //da dare un nome
bool switch4=sensori[3];                //da dare un nome
bool switch5=sensori[4];                //da dare un nome
bool switch6=sensori[5];                //da dare un nome

int switch_aperto;
int switch_chiuso;

Shifter scheda_8relay;          //!! pinout defined in library

int main()
{
    setup_griglia();
    lcd.SetBackColor(light_sky_blue);
    lcd.SetFont(&Font24);
    lcd.SetTextColor(black);
    while(1) {
//acquisisco la pressione sullo schermo per attivare i vari oggetti
        ts.ResetTouchData(&TS_State);
        ts.GetState(&TS_State);
        X = TS_State.touchX[0];                             //acquisisco la X
        Y = TS_State.touchY[0];                             //acquisisco la Y

        if (X>=20 && X<120 && Y>=20 && Y<80)    {       //ROAST
            roast(160,900);
        }
        if (X>=20 && X<120 && Y>=90 && Y<150)   {       //CLEAN
            clean(7200, 430.0, 460.0);
        }
        if (X>=20 && X<120 && Y>=160 && Y<220)  {       //STOP

        }
        if (TS_State.touchDetected) wait(0.1);

        object_update();
        
        wait(0.1);
    }//close while(1)
}//close main

//CLEAN
void clean(int clean_time, float setpointLOW, float setpointHIGH)
{
    Timer timer;
    timer.start();
    int previous_time, actual_time;
    previous_time = timer.read();
    Lampadina.stato=0;
    Resistenza1.stato=1;
    Resistenza2.stato=1;
    Cooling.stato=1;            //accendo ventilazione raffreddamento
    Bloccoporta.stato=1;        // chiudo porta
    lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"CLEAN ATTIVO    ", LEFT_MODE); 
    // dovrei verificare se il tappo caffé è chiuso ma per ora non ho switch, aggiungere oggetto switch1

    // dovrei verificare se sportello caffé chiuso, aggiungere oggetto switch2

    while(1) {
        actual_time = timer.read();
        uint8_t text[30];
        //acquisisco la pressione sullo schermo per attivare i vari oggetti
        ts.ResetTouchData(&TS_State);
        ts.GetState(&TS_State);
        int X = TS_State.touchX[0];                             //acquisisco la X
        int Y = TS_State.touchY[0];                             //acquisisco la Y
        if (X>=20 && X<120 && Y>=160 && Y<220) {                //STOP
            stop();
            break;
        }
        //countdown dal clean_time a zero
        if (actual_time-previous_time >=1) {
            lcd.SetTextColor(black);
            sprintf((char*)text, "%5d", clean_time);
            lcd.DisplayStringAt(130,100, (uint8_t *)&text, LEFT_MODE);
            previous_time = actual_time;
            clean_time--;
        }
        //se il tempo di clean è finito porto gli output a zero e aggiorno, poi esco dal ciclo
        if (clean_time<0) {
            stop();
            break;
        }

        // regolo temperatura clean       
        if (Temperatura_forno.read() < setpointLOW) {
            Resistenza1.stato=1;
            object_update();
            //acquisisco la pressione sullo schermo per attivare i vari oggetti
            ts.ResetTouchData(&TS_State);
            ts.GetState(&TS_State);
            int X = TS_State.touchX[0];                             //acquisisco la X
            int Y = TS_State.touchY[0];                             //acquisisco la Y
            if (X>=20 && X<120 && Y>=160 && Y<220) {                //STOP
                stop();
                break;
            }
        }
        if (Temperatura_forno.read() > setpointHIGH) {
            Resistenza1.stato=0;
            object_update();
            //acquisisco la pressione sullo schermo per attivare i vari oggetti
            ts.ResetTouchData(&TS_State);
            ts.GetState(&TS_State);
            int X = TS_State.touchX[0];                             //acquisisco la X
            int Y = TS_State.touchY[0];                             //acquisisco la Y
            if (X>=20 && X<120 && Y>=160 && Y<220) {                //STOP
                stop();
                break;
            }
        }
        object_update();
    }
}

//STOP
void stop()
{
    //imposto TUTTI gli output, poi aggiorno
    Bloccoporta.stato=1;
    Cooling.stato=1;
    Ventilatore_turbo.stato=0;
    Lampadina.stato=0;
    Resistenza1.stato=0;
    Resistenza2.stato=0;
    Girarrosto.stato=0;
    Scarico_caffe.fermo();
    Ventilatore2.stato=0;
    object_update();
    lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"    S T O P     ", LEFT_MODE);
    //da correggere, mettere le 2 grandezze nella stessa dimensione
    while (Temperatura_forno.read()>150) {
        wait(1.0);
        // scrivo qualcosa a video??
    }
    Cooling.stato=0;                // spengo ventilazione raffreddamento
    Bloccoporta.stato=0;            // apro porta
    object_update();
}

//SPORTELLO_SCARICO
void sportello_scarico(bool isDoorOpen)
{
    if (isDoorOpen) {
        while (switch_aperto==0) {
            Scarico_caffe.avanti();
            object_update();
            lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"MOTORE AVANTI   ", LEFT_MODE); 
        }
    } else {
        while (switch_aperto==0) {
            Scarico_caffe.indietro();
            object_update();
            lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"MOTORE INDIETRO ", LEFT_MODE);
        }
    }
    Scarico_caffe.fermo();
    object_update();
}

//ROAST
void roast (int roast_temp, int roast_time)
{
    Timer timer;
    timer.start();
    int previous_time, actual_time;
    previous_time = timer.read();
    // ************* PREHEATING *****************
    lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"ROAST PREHEATING", LEFT_MODE);
    bool pre=1;
    Lampadina.stato=1;                      // accendo lampadina
    Ventilatore_turbo.stato=1;              // accendo ventilazione raffreddamento
    Bloccoporta.stato=1;                    // chiudo porta
    // dovrei verificare se il tappo caffé è chiuso ma per ora non ho switch, aggiungere oggetto switch1
    // dovrei verificare se sportello caffé chiuso, aggiungere oggetto switch2

    while(Temperatura_forno.read()<roast_temp and pre) {
        Resistenza1.stato=1;
        Resistenza2.stato=1;
        object_update();
        actual_time = timer.read();
        uint8_t text[30];

        // scrivo a video qualcosa ....

        //acquisisco la pressione sullo schermo per attivare i vari oggetti
        ts.ResetTouchData(&TS_State);
        ts.GetState(&TS_State);
        int X = TS_State.touchX[0];                             //acquisisco la X
        int Y = TS_State.touchY[0];                             //acquisisco la Y
        if (X>=20 && X<120 && Y>=160 && Y<220) {                //STOP
            stop();
            break;
        }
    }

    pre=0;
    // ************* ROAST *******************
    lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"ROAST           ", LEFT_MODE);
    Resistenza2.stato=0;                // spengo extra resistenza
    Girarrosto.stato=1;                 // faccio partire motore mescolatore
    Ventilatore_turbo.stato=1;          // faccio partire turbo
    object_update();

    // aspetto carico caffé
    /*
    while (switch_carico=aperto)
    {
        }
    */

    //se il tempo di roast è finito porto gli output a zero e aggiorno, poi esco dal ciclo
    while (roast_time>0) {
        actual_time = timer.read();
        uint8_t text[30];
        //acquisisco la pressione sullo schermo per attivare i vari oggetti
        ts.ResetTouchData(&TS_State);
        ts.GetState(&TS_State);
        int X = TS_State.touchX[0];                             //acquisisco la X
        int Y = TS_State.touchY[0];                             //acquisisco la Y
        if (X>=20 && X<120 && Y>=160 && Y<220) {                //STOP
            // stop();
            break;
        }
        //countdown dal roast_time a zero
        if (actual_time-previous_time >=1) {
            lcd.SetFont(&Font24);
            lcd.SetTextColor(black);
            sprintf((char*)text, "%5d", roast_time);
            lcd.DisplayStringAt(130,100, (uint8_t *)&text, LEFT_MODE);
            previous_time = actual_time;
            roast_time--;
            // regolo temperatura roast
            if (Temperatura_sonda1.read()<roast_temp-5) {
                Resistenza1.stato=1;
                // aggiorno stato video
            }
            if (Temperatura_sonda1.read()>roast_temp+5) {
                Resistenza1.stato=0;
                // aggiorno stato video
            }
            object_update();
        }

        // *************** scarico caffè ***********
        Resistenza1.stato=0;        //spengo forno
        Ventilatore2.stato=1;       // accendo raffreddamento cassetto
        object_update();
        wait(2);
        sportello_scarico(1);       // apro scarico
        wait(2);
        sportello_scarico(0);       // chiudo scarico
        // aspetto 1 minuto e spengo raffreddamento caffé
        wait(60);
    }
    // spengo tutto
    stop();
}

//OBJECT_UPDATE
void object_update()
{
    //update delle immagini e dello stato delle uscite
    //disegno lo stato dei vari oggetti
    Lampadina.draw_image    (&_acLampadina_acceso[0], &_acLampadina_spento[0], Lampadina.stato, 310, 0);
    Ventilatore_turbo.draw_image       (&_acVentilatore_turbo_acceso[0], &_acVentilatore_turbo_spento[0], Ventilatore_turbo.stato, 310, 60);
    Cooling.draw_image (&_acCooling_acceso[0], &_acCooling_spento[0], Cooling.stato, 310, 120);
    Ventilatore2.draw_image (&_acVentilatore2_acceso[0], &_acVentilatore2_spento[0], Ventilatore2.stato, 310, 180);
    Bloccoporta.draw_image  (&_acBloccoporta_acceso[0], &_acBloccoporta_spento[0], Bloccoporta.stato, 360, 0);
    Girarrosto.draw_image   (&_acGirarrosto_acceso[0], &_acGirarrosto_spento[0], Girarrosto.stato, 360, 60);
    Resistenza1.draw_image  (&_acResistenza1_acceso[0], &_acResistenza1_spento[0], Resistenza1.stato, 360, 120);
    Resistenza2.draw_image  (&_acResistenza2_acceso[0], &_acResistenza2_spento[0], Resistenza2.stato, 360, 180);
    //update uscita 74HC595
    bool array[16]= {Bloccoporta.stato, Girarrosto.stato, Lampadina.stato, Ventilatore_turbo.stato, Resistenza1.stato, Resistenza2.stato, Cooling.stato, Ventilatore2.stato, Scarico_caffe.DCmotorA1, Scarico_caffe.DCmotorA2, 0,0,0,0,0,0};
    for (int i=0; i<16; i++) scheda_8relay.setPin(i,array[i]);
    scheda_8relay.write();
    //update sensori ingresso
    sensori=Sensore.Read();
    /*
    for (int i=7; i>=0; i--) {  //D7,D6,.....,D1,D0
        sprintf((char*)text, "%d", sensori[0+i]);
        lcd.DisplayStringAt(10,LINE(i), (uint8_t *)&text, LEFT_MODE);    
        printf(" %d", sensori[0+i]);        
        }*/
}