#include "mbed.h"
#include "TS_DISCO_F469NI.h"
#include "LCD_DISCO_F469NI.h"
#include "MAX31865.h"

#include "AClean_0.c"
#include "AClean_1.c"
#include "ARoast_0.c"
#include "ARoast_1.c"
#include "ARoast_2.c"
#include "APower.c"

#include "APulsanti.c"
#include "Porta_aperto.c"
#include "Porta_chiuso.c"
#include "Giracaffe_acceso.c"
#include "Giracaffe_spento.c"
#include "Lampadina_acceso.c"
#include "Lampadina_spento.c"
#include "VTangenziale_acceso.c"
#include "VTangenziale_spento.c"
#include "VRadiale_acceso.c"
#include "VRadiale_spento.c"
#include "Resistenza1_acceso.c"
#include "Resistenza1_spento.c"
#include "Resistenza2_acceso.c"
#include "Resistenza2_spento.c"
#include "Ventola_acceso.c"
#include "Ventola_spento.c"

#include "functions.h"
#include "colors.c"
#include "Output.h"

extern void clean(int, float, float);
extern void roast(int, int);
extern void stop(bool);

extern void temperature_update();

bool stato_porta=0;             //da cancellare, solo per prova porta
bool isPreRoastFinished=0;

int main()
{
    setup_griglia();            //setup, parte grafica

    while(1) {
        getData();
        temperature_update();
//acquisisco la pressione sullo schermo per attivare i vari oggetti
        ts.GetState(&TS_State);
        X = TS_State.touchX[0];                                                 //acquisisco la X
        Y = TS_State.touchY[0];                                                 //acquisisco la Y

//------------------------------------------------------------------------------
///solo per prova
        if ((TS_State.touchDetected) && (X>=230 && X<300 && Y>=20 && Y<90))    {
            Lampadina.stato=!Lampadina.stato;
            object_update();
        }
        if ((TS_State.touchDetected) && (X>=300 && X<370 && Y>=20 && Y<90))    {
            Resistenza1.stato=!Resistenza1.stato;
            object_update();
        }
        if ((TS_State.touchDetected) && (X>=370 && X<440 && Y>=20 && Y<90))    {
            Resistenza2.stato=!Resistenza2.stato;
            object_update();
        }
        if ((TS_State.touchDetected) && (X>=440 && X<510 && Y>=20 && Y<90))    {
            Giracaffe.stato=!Giracaffe.stato;
            object_update();
        }
        if ((TS_State.touchDetected) && (X>=230 && X<300 && Y>=90 && Y<160))   {
            stato_porta=!stato_porta;
            (stato_porta==1) ? chiudo_porta() : apro_porta();
        }
        if ((TS_State.touchDetected) && (X>=300 && X<370 && Y>=90 && Y<160))   {
            VTangenziale.stato=!VTangenziale.stato;
            object_update();
        }
        if ((TS_State.touchDetected) && (X>=370 && X<440 && Y>=90 && Y<160))   {
            VRadiale.stato=!VRadiale.stato;
            object_update();
        }
        if ((TS_State.touchDetected) && (X>=440 && X<510 && Y>=90 && Y<160))   {
            Ventola.stato=!Ventola.stato;
            object_update();
        }
        if ((TS_State.touchDetected) && (X>=620 && X<690 && Y>=20 && Y<90))    {
            Apro_scarico();
        }
        if ((TS_State.touchDetected) && (X>=620 && X<690 && Y>=100 && Y<170))  {
            Chiudo_scarico();
        }
//------------------------------------------------------------------------------
        //if ROAST pressed
        if ((TS_State.touchDetected) && (X>=20 && X<140 && Y>=290 && Y<410))   {
            roast(temperatura_roast,tempo);
        }
        //if CLEAN pressed
        if ((TS_State.touchDetected) && (X>=20 && X<140 && Y>=165 && Y<285))   {
            clean(clean_time, setpointLOW, setpointHIGH);
        }
        //if STOP pressed
        if ((TS_State.touchDetected) && (X>=20 && X<140 && Y>=20 && Y<140))    {
            stop(1);
        }
        //if TEMPERATURA UPPER pressed
        if ((TS_State.touchDetected) && (X>=200 && X<260 && Y>=270 && Y<330))  {
            temperatura = temperatura+5;
            if (temperatura >300) temperatura =300;
        }
        //if TEMPERATURA LOWER pressed
        if ((TS_State.touchDetected) && (X>=200 && X<260 && Y>=350 && Y<410))  {
            temperatura = temperatura-5;
            if (temperatura <150) temperatura =150;
        }
        //if TEMPO UPPER pressed
        if ((TS_State.touchDetected) && (X>=325 && X<385 && Y>=270 && Y<330))  {
            tempo = tempo+15;
            if (tempo >3000) tempo =3000;
        }
        //if TEMPO LOWER pressed
        if ((TS_State.touchDetected) && (X>=325 && X<385 && Y>=350 && Y<410))  {
            tempo = tempo-15;
            if (tempo <120) tempo =120;
        }
//------------------------------------------------------------------------------
//scrivo minuti e secondi
        int minuti = tempo/60;
        int secondi = tempo%60;
        sprintf((char*)text, "%2d", minuti);
        lcd.DisplayStringAt(295,LINE(8), (uint8_t *)&text, LEFT_MODE);
        sprintf((char*)text, "%2d", secondi);
        lcd.DisplayStringAt(350,LINE(8), (uint8_t *)&text, LEFT_MODE);
//scrivo temperatura
        sprintf((char*)text, "%3d", temperatura);
        lcd.DisplayStringAt(295,LINE(10), (uint8_t *)&text, LEFT_MODE);
//------------------------------------------------------------------------------
        object_update();
        wait(0.1);
    }//close while(1)
}//close main

//CLEAN
void clean(int clean_time, float setpointLOW, float setpointHIGH)
{
    disegna_pulsanti(CLEAN_ATTIVO);
    Lampadina_spento();
    Ventola_spento();
    VRadiale_spento();
    VTangenziale_acceso();
    Giracaffe_spento();
    Resistenza1_spento();
    Resistenza2_spento();
    Chiudo_scarico();                                                           //chiudo lo scarico del caffè
    //non procedo fino a quando la porta non è chiusa e anche il tappo del caffè
    do {
        ///
    } while (!chiudo_porta());

    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"CLEAN ACTIVE             ", LEFT_MODE);
    Timer timer;
    timer.start();
    int previous_time, actual_time;
    previous_time = timer.read();
    VRadiale_acceso();
    while(1) {
        actual_time = timer.read();
        uint8_t text[30];
        //acquisisco la pressione sullo schermo per vedere se devo stoppare il ciclo mentre faccio il clean
        ts.GetState(&TS_State);
        int X = TS_State.touchX[0];
        int Y = TS_State.touchY[0];
        if ((TS_State.touchDetected) && (X>=20 && X<140 && Y>=235 && Y<335)) {                //STOP
            stop(0);
            break;
        }
        //se la temperatura è sotto il setpoint high continuo a riscaldare, se la temperatura scende sotto il setpoint low ricomincio a riscaldare
        temperature_update();
        if (PT1.temperature( )<=setpointLOW)  {
            Resistenza1_acceso();
            Resistenza2_acceso();
        }
        if (PT1.temperature( )>setpointHIGH)  {
            Resistenza1_spento();
            Resistenza2_spento();
        }
        //countdown dal clean_time a zero
        if (actual_time-previous_time >=1) {
            lcd.SetTextColor(black);
            sprintf((char*)text, "%5d", clean_time);
            lcd.DisplayStringAt(210,LINE(18), (uint8_t *)&text, LEFT_MODE);
            previous_time = actual_time;
            clean_time--;
        }
        //se il tempo di clean è finito avvio la procedura di stop
        if (clean_time<0) {
            stop(0);
            break;
        }
    }
}

//STOP procedura di stop
void stop(bool clean_roast)
{
    //stop(0) se era in esecuzione il cleaning
    //stop(1) se era in esecuzione il roasting
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"STOP                     ", LEFT_MODE);
    lcd.DisplayStringAt(260,LINE(18), (uint8_t *)"      ", LEFT_MODE);
    //spengo le resistenze
    Resistenza1_spento();
    Resistenza2_spento();
    do {
        temperature_update();
        lcd.SetTextColor(red);
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"TEMPERATURE   ABOVE   150", LEFT_MODE);
        wait (2.0);
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"NOT POSSIBLE TO OPEN DOOR", LEFT_MODE);
        wait (2.0);
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                         ", LEFT_MODE);
        wait (2.0);
        lcd.SetTextColor(black);
    } while (PT1.temperature( )>temp_safe);
    wait (5.0);

    //spengo tutto
    VRadiale_spento();
    VTangenziale_spento();
    Lampadina_spento();
    //scarico caffe
    if (clean_roast) {
        Apro_scarico();
        Ventola_acceso();
        Giracaffe_acceso();
        wait (10);
        Giracaffe_spento();
        wait(290);
    }
    Ventola_spento();
    Giracaffe_spento();
    //apertura porta
    apro_porta();
}

//ROAST
void roast (int roast_temp, int roast_time)
{
    disegna_pulsanti(ROAST_PRE);
    Timer timer;
    int previous_time, actual_time;
    Lampadina_acceso();
    Ventola_spento();
    VRadiale_spento();
    VTangenziale_acceso();
    Giracaffe_spento();
    Resistenza1_spento();
    Resistenza2_spento();
    Chiudo_scarico();                                                           //chiudo lo scarico del caffè
    //non procedo fino a quando la porta non è chiusa e anche il tappo del caffè
    do {
        ///
    } while (!chiudo_porta());
    temperature_update();
    if (PT1.temperature( )<=roast_temp-10)  {
        Resistenza1_acceso();
        Resistenza2_acceso();
    }
    if (PT1.temperature( )>roast_temp+10)  {
        Resistenza1_spento();
        disegna_pulsanti(ROAST_ACTIVE);
        if (!isPreRoastFinished) {
            disegna_pulsanti(ROAST_ACTIVE);
            timer.start();
            previous_time = timer.read();
            isPreRoastFinished=1;
        }
    }

}
