#ifndef FUCTIONS_H
#define FUNCTIONS_H

#include "colors.c"
#include "mbed.h"
#include "Output.h"
#include "Shifter.h"
#include "LCD_DISCO_F469NI.h"

LCD_DISCO_F469NI lcd;
TS_DISCO_F469NI ts;
uint16_t X, Y;
uint8_t status;
uint8_t cleared = 0;
uint8_t prev_nb_touches = 0;
uint8_t text[30];

TS_StateTypeDef TS_State;

Serial pc(SERIAL_TX, SERIAL_RX);
MAX31865_RTD PT1(MAX31865_RTD::RTD_PT100,D11, D12, D13, A0);
MAX31865_RTD PT2(MAX31865_RTD::RTD_PT100,D11, D12, D13, A1);
MAX31865_RTD PT3(MAX31865_RTD::RTD_PT100,D11, D12, D13, A2);



/// dichiarazione variabili ////////////////////////////////////////////////////
//per i sensori
static bool myDataIn[8] = {1,0,1,0,1,0,1,0};
//myDataIn[0]               tappo caffè chiuso;
//myDataIn[1]               sensore porta chiusa;
//myDataIn[2]               finecorsa sarico aperto;
//myDataIn[3]               finecorsa scarico chiuso;
//myDataIn[4];               //da dare un nome
//myDataIn[5];               //da dare un nome
//myDataIn[6];               //da dare un nome
//myDataIn[7];               //da dare un nome

//per i relay
Shifter scheda_8relay;                  //!! pinout defined in library
Output Bloccoporta;                     //
Output Giracaffe;                       // palette agita caffé
Output Lampadina;                       // Lampadina
Output VTangenziale;                    // 1
Output VRadiale;                        // 2
Output Scarico_caffe;                   // motore scarico caffé
Output Resistenza1;                     //
Output Resistenza2;                     //
Output Ventola;                         // cooling

bool Activate_Door;                     //sul SSR per comandare il bloccoporta

/// funzioni ///////////////////////////////////////////////////////////////////
bool setup_griglia()
{
    lcd.Clear(light_sky_blue);
    lcd.SetBackColor(light_sky_blue);
    lcd.SetFont(&Font24);
    lcd.SetTextColor(black);
    lcd.DisplayStringAt(670, LINE(0), (uint8_t *)"Ver 1.0", LEFT_MODE);
    //     STOP  CLEAN ROAST
    int riga, colonna, contatore=0;
    //STOP
    contatore=0;
    for (riga=0; riga<120; riga++)  {
        for ( colonna=0; colonna<120; colonna++)  {
            lcd.DrawPixel (20+colonna, 20+ riga, _acAPower[contatore]);
            contatore++;
        }
        colonna=0;
    }
    //lcd.DrawRect (20, 20, 120, 120); 
    //--------------------------------------------------------------------------    
    //CLEAN
    contatore=0;
    for (riga=0; riga<120; riga++)  {
        for ( colonna=0; colonna<120; colonna++)  {
            lcd.DrawPixel (20+colonna, 165+ riga, _acAClean[contatore]);
            contatore++;
        }
        colonna=0;
    }
    //lcd.DrawRect (20, 165, 120, 120);     
    //--------------------------------------------------------------------------    
    //ROAST
    contatore=0; 
    for (riga=0; riga<120; riga++)  {
        for ( colonna=0; colonna<120; colonna++)  {
            lcd.DrawPixel (20+colonna, 290+ riga, _acARoast[contatore]);
            contatore++;
        }
        colonna=0;
    }
    //lcd.DrawRect (20, 290, 120, 120);
    //--------------------------------------------------------------------------    
    //PULSANTI
    contatore=0;
    for (riga=0; riga<140; riga++)  {
        for ( colonna=0; colonna<200; colonna++)  {
            lcd.DrawPixel (180+colonna, 270+ riga, _acAPulsanti[contatore]);
            contatore++;
        }
        colonna=0;
    }
        //lcd.DrawRect (180, 270, 200, 140); 
        //lcd.DrawRect (220, 270, 60, 60); 
        //lcd.DrawRect (325, 270, 60, 60);
        //lcd.DrawRect (220, 350, 60, 60);
        //lcd.DrawRect (325, 350, 60, 60);
    
    lcd.DisplayStringAt(200, LINE( 8),  (uint8_t *)"Time:", LEFT_MODE);
    lcd.DisplayStringAt(330, LINE(8), (uint8_t *)"'", LEFT_MODE);
    lcd.DisplayStringAt(385, LINE(8), (uint8_t *)"''", LEFT_MODE);
    lcd.DisplayStringAt(200, LINE( 10), (uint8_t *)"Temp:", LEFT_MODE);
    lcd.DrawCircle(355, LINE(10)+3, 4);
    lcd.DisplayStringAt(360, LINE( 10), (uint8_t *)"C", LEFT_MODE);
    lcd.DisplayStringAt(620, LINE( 9), (uint8_t *)"T1:", LEFT_MODE);
    lcd.DisplayStringAt(620, LINE(11), (uint8_t *)"T2:", LEFT_MODE);
    lcd.DisplayStringAt(620, LINE(13), (uint8_t *)"T3:", LEFT_MODE);
    
    //per prova, da togliere dopo 
    lcd.SetTextColor(red);
    lcd.FillRect (620, 20, 70, 70);    
    lcd.SetTextColor(green);
    lcd.FillRect (620, 100, 70, 70); 
    lcd.SetTextColor(black);
    //fino qui
    
    PT1.configure( true, true, false, true, MAX31865_FAULT_DETECTION_NONE,
                   true, true, 0x0000, 0x7fff );
    PT2.configure( true, true, false, true, MAX31865_FAULT_DETECTION_NONE,
                   true, true, 0x0000, 0x7fff );
    PT3.configure( true, true, false, true, MAX31865_FAULT_DETECTION_NONE,
                   true, true, 0x0000, 0x7fff );
                   
    return 0;
}
//------------------------------------------------------------------------------
bool * getData()
{
    //define where your pins are
    DigitalOut latchPin(D7);
    DigitalOut clockPin(D6);
    DigitalIn  dataPin(D5);
    float tempoattesa = 20;
    //acquiring values
    latchPin.write(1);
    wait_us(tempoattesa);
    //read values acquired and store in array
    latchPin.write(0);
    for (int i=7; i>=0; i--) {
        wait_us(tempoattesa);
        clockPin.write(0);
        wait_us(tempoattesa);
        myDataIn[i] = dataPin.read();      //1 if OT open, 0 if OT close
        clockPin.write(1);
    }
    for (int i=7; i>=0; i--) {  // D7,D6,.....,D1,D0
        sprintf((char*)text, "%d", myDataIn[0+i]);
        lcd.DisplayStringAt(580+20*i,LINE(8), (uint8_t *)&text, LEFT_MODE);
    }
    return myDataIn;
}
//------------------------------------------------------------------------------
void object_update()
{
    //update delle immagini e dello stato delle uscite
    Lampadina.draw_image    (&_acLampadina_acceso[0], &_acLampadina_spento[0], Lampadina.stato, 230, 20);
    Resistenza1.draw_image  (&_acResistenza1_acceso[0], &_acResistenza1_spento[0], Resistenza1.stato, 300, 20);
    Resistenza2.draw_image  (&_acResistenza2_acceso[0], &_acResistenza2_spento[0], Resistenza2.stato, 370, 20);
    Giracaffe.draw_image    (&_acGiracaffe_acceso[0], &_acGiracaffe_spento[0], Giracaffe.stato, 440, 20);
    Bloccoporta.draw_image  (&_acPorta_aperto[0], &_acPorta_chiuso[0], Bloccoporta.stato, 230, 90);
    VTangenziale.draw_image (&_acVTangenziale_acceso[0], &_acVTangenziale_spento[0], VTangenziale.stato, 300, 90);
    VRadiale.draw_image     (&_acVRadiale_acceso[0], &_acVRadiale_spento[0], VRadiale.stato, 370, 90);
    Ventola.draw_image      (&_acVentola_acceso[0], &_acVentola_spento[0], Ventola.stato, 440, 90);
    //update uscita 74HC595
    bool array[16]= {!Lampadina.stato, !Giracaffe.stato, !VTangenziale.stato, !Resistenza1.stato, !Resistenza2.stato, !VRadiale.stato, !Scarico_caffe.ON_OFF, !Scarico_caffe.CW_CCW, !Ventola.stato, Activate_Door,1,1,1,1,1,1};
    for (int i=0; i<16; i++) scheda_8relay.setPin(i,array[i]);
    scheda_8relay.write();
}
//------------------------------------------------------------------------------
void temperature_update()
{
    PT1.read_all( );
        sprintf((char*)text, "%1.0f", PT1.temperature( ));
        if (PT1.temperature( )>150)  lcd.SetTextColor(red);
        else lcd.SetTextColor(black);
        lcd.DisplayStringAt(680, LINE(9), (uint8_t *)&text, LEFT_MODE);
    PT2.read_all( );
        sprintf((char*)text, "%1.0f", PT2.temperature( ));
        if (PT2.temperature( )>150)  lcd.SetTextColor(red);
        else lcd.SetTextColor(black);
        lcd.DisplayStringAt(680, LINE(11), (uint8_t *)&text, LEFT_MODE);  
    PT3.read_all( );
        sprintf((char*)text, "%1.0f", PT3.temperature( ));
        if (PT3.temperature( )>150)  lcd.SetTextColor(red);
        else lcd.SetTextColor(black);
        lcd.DisplayStringAt(680, LINE(13), (uint8_t *)&text, LEFT_MODE);
}        
        
//------------------------------------------------------------------------------
/// Lampadina
void Lampadina_acceso()
{
    Lampadina.stato=1;
    object_update();
}
void Lampadina_spento()
{
    Lampadina.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
/// Resistenza 1
void Resistenza1_acceso()
{
    Resistenza1.stato=1;
    object_update();
}
void Resistenza1_spento()
{
    Resistenza1.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
/// Resistenza 2
void Resistenza2_acceso()
{
    Resistenza2.stato=1;
    object_update();
}
void Resistenza2_spento()
{
    Resistenza2.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
/// Ventola 12/24 volt
void Ventola_acceso()
{
    Ventola.stato=1;
    object_update();
}
void Ventola_spento()
{
    Ventola.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
/// Ventola Radiale
void VRadiale_acceso()
{
    VRadiale.stato=1;
    object_update();
}
void VRadiale_spento()
{
    VRadiale.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
/// Ventola Tangenziale
void VTangenziale_acceso()
{
    VTangenziale.stato=1;
    object_update();
}
void VTangenziale_spento()
{
    VTangenziale.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
/// Giracaffe
void Giracaffe_acceso()
{
    Giracaffe.stato=1;
    object_update();
}
void Giracaffe_spento()
{
    Giracaffe.stato=0;
    object_update();
}
//------------------------------------------------------------------------------
///Apro scarico caffe
bool Apro_scarico()
{
    do {
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"SCARICO CAFFE            ", LEFT_MODE);
        Scarico_caffe.CW_CCW=1;
        object_update();
        wait(0.5);
        Scarico_caffe.ON_OFF=1;
        object_update();
        getData();
        }while(!myDataIn[2]);
    Scarico_caffe.ON_OFF=0; 
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                             ", LEFT_MODE);  
    wait(0.4);  
    return 0;
}
///Chiudo scarico
bool Chiudo_scarico()
{
    do {
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"CHIUDO SCARICO           ", LEFT_MODE);
        Scarico_caffe.CW_CCW=0;
        object_update();
        wait(0.5);
        Scarico_caffe.ON_OFF=1;
        object_update();
        getData();
        }while(!myDataIn[3]);
    Scarico_caffe.ON_OFF=0; 
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                             ", LEFT_MODE);  
    wait(0.4); 
    return 0;
}
//------------------------------------------------------------------------------
///Porta
bool apro_porta()
{   
    //attivazione del relay
    Activate_Door=0;
    object_update();
    wait(0.100); 
    Activate_Door=1;
    object_update();
    wait(0.050);
    Activate_Door=0;
    object_update();
    wait(0.200);
    Activate_Door=1;
    object_update();
    wait(0.050);
    Activate_Door=0;
    object_update();
    ///
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"PORTA APERTA             ", LEFT_MODE);
    wait(1.0);
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                         ", LEFT_MODE);
    Bloccoporta.stato=0;
    object_update();
    return 0;
}
bool chiudo_porta()
{
    do {    
    } while (!Chiudo_scarico());
    do {
        getData();
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"CHIUDI IL TAPPO CAFFE'   ", LEFT_MODE);
        wait(0.1);
    } while (!myDataIn[0]);
    do {
        getData();
        lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"CHIUDI LA PORTA          ", LEFT_MODE);
        wait(0.1);
    } while (!myDataIn[1]);        //NB porta chiusa lo stato logico è =1, se è aperta lo stato logico è 0 e il ciclo while, finatanto che, non è fatto, ecco il perchè della negazione
    //attivazione del relay per chiudere la porta
    Activate_Door=0;
    object_update();
    wait(0.100); 
    Activate_Door=1;
    object_update();
    wait(0.050);
    Activate_Door=0;
    object_update();
    wait(0.100);
    ///
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"PORTA CHIUSA             ", LEFT_MODE);
    Bloccoporta.stato=1;
    object_update();
    wait(1.200);
    lcd.DisplayStringAt(10, LINE(18), (uint8_t *)"                         ", LEFT_MODE);
    return 0;
}
//End of Functions//
#endif
