#include "CD74HC165E.h"

#define HIGH 1
#define LOW  0

int WaitingTime=1;
//CD74HC165E
//PL pin 1
//CP pin 2
//CE pin 15
//Q7 pin 9



CD74HC165E::CD74HC165E (PinName PL, PinName CP, PinName Q7) : _PL(PL), _CP(CP), _Q7(Q7)
{
_PL = LOW;
_CP = LOW;
//_Q7 no perchè è una uscita e non ingresso
}

bool* CD74HC165E::Read()    {
//achieving data D0-D7
_CP = LOW;
wait_us(WaitingTime); 
_PL = LOW; 
wait_us(WaitingTime*5);   // 5 microseconds to be sure to achieve all data D0-D7
_PL = HIGH; 

//store data in array
static bool myDataIn[8] = {1,0,1,0,1,0,1,0}; 
wait_us(WaitingTime);  
for (int i=7; i>=0; i--) {
    _CP = LOW;
    wait_us(WaitingTime);
    myDataIn[i] = _Q7;      
    _CP = HIGH;
    wait_us(WaitingTime);      
    }
    
return myDataIn;
}