#ifndef FUCTIONS_H
#define FUNCTIONS_H

//GOOD 0, GOOD/ERROR LATCHED 1, ERROR 2

/// FUNZIONI ///////////////////////////////////////////////////////////////////

void function_PREV_NEXT()
{
    // se premo nella barra inferiore cambio foglio/////////////////////////
    //if PREV pressed
    if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=1 && TS_State.touchX[0]<160 && TS_State.touchY[0]>=400)) {
        actual_sheet = actual_sheet--;
        if (actual_sheet < 0) {
            actual_sheet = total_sheet-1;
        }
        display_draw_sheet(actual_sheet);
        wait_ms(120);
    }
    //if NEXT pressed
    if ( (TS_State.touchDetected) && (TS_State.touchX[0]>=641 && TS_State.touchX[0]<800 && TS_State.touchY[0]>=400)) {
        actual_sheet = actual_sheet++;
        if (actual_sheet >= total_sheet) {
            actual_sheet = 0;
        }
        display_draw_sheet(actual_sheet);
        wait_ms(120);
    }
}

//------------------------------------------------------------------------------
void function_check_OT()
{
    float tempoattesa = 20;
    //acquiring values
    latchPin.write(1);
    wait_us(tempoattesa);
    //read values acquired and store in array
    latchPin.write(0);
    for (int i=7; i>=0; i--) {
        wait_us(tempoattesa);
        clockPin.write(0);
        wait_us(tempoattesa);
        //OT[i].state = dataPin.read();                                         //OT open is ok, OT close is error
        OT[i].state = !dataPin.read();                                          //OT open is error, OT close is OK
        if (OT[i].state) OT[i].latch_error = 1;
        if (OT[i].latch_error) (OT[i].state == 1) ? OT[i].state= 2 : OT[i].state = 1;       
        clockPin.write(1);
    }
}
//------------------------------------------------------------------------------
void print_OT_alarmed()
{
    lcd.SetFont(&Font24);
    lcd.SetTextColor(black);
    lcd.SetBackColor(BackColor);
    if (OT[0].latch_error) lcd.DisplayStringAt(35, LINE(11), (uint8_t *)"OT 510 LWR TRNS", LEFT_MODE);
    if (OT[1].latch_error) lcd.DisplayStringAt(35, LINE(12), (uint8_t *)"OT 512 LWR TRNS", LEFT_MODE);
    if (OT[2].latch_error) lcd.DisplayStringAt(35, LINE(13), (uint8_t *)"OT 51 LWR ZONE 2", LEFT_MODE);
    if (OT[3].latch_error) lcd.DisplayStringAt(35, LINE(14), (uint8_t *)"OT 52 LWR ZONE 2", LEFT_MODE);
    if (OT[4].latch_error) lcd.DisplayStringAt(425, LINE(11), (uint8_t *)"OT 54 LWR ZONE 2", LEFT_MODE);
    if (OT[5].latch_error) lcd.DisplayStringAt(425, LINE(12), (uint8_t *)"OT 55 LWR ZONE 1", LEFT_MODE);
    if (OT[6].latch_error) lcd.DisplayStringAt(425, LINE(13), (uint8_t *)"OT 57 LWR ZONE 1", LEFT_MODE);
    if (OT[7].latch_error) lcd.DisplayStringAt(425, LINE(14), (uint8_t *)"OT 58 LWR ZONE 1", LEFT_MODE);   
}
//------------------------------------------------------------------------------
void function_check_heaters(int sample)
{
    //signal value
    Heater[0].average = 0;
    Heater[1].average = 0;
    for (int i=0; i<3; i++) {
        Heater[0].average = Heater[0].average + abs((3.6 * abs(signalHeater1.read()) - 1.8));
        Heater[1].average = Heater[1].average + abs((3.6 * abs(signalHeater2.read()) - 1.8));
        wait_us(10);
    }
    Heater[0].average = Heater[0].average/3;
    Heater[1].average = Heater[1].average/3;
    
    //if heater is activate .ON_OFF = 1, else = 0
    for (int i=0; i<MAX_HEATER; i++) {
        (Heater[i].average >= Heater[i].limit) ? Heater[i].ON_OFF = 1 : Heater[i].ON_OFF = 0;
        Heater_Samples[i][sample] = Heater[i].ON_OFF;
    }
    
    //define Heater[i].state GOOD = 0, LATCHED = 1, ERROR = 2 investigating ALL samples, OR qualificator among samples
    for (int i=0; i<MAX_HEATER; i++) {
        int a_samples = 0;       
        for (a_samples = 0; a_samples < MAX_Samples; a_samples++) {
           Heater[i].state = Heater[i].state || Heater_Samples[i][a_samples];
        }
        Heater[i].state = 1 - Heater[i].state;
        a_samples=0;
        //latch di memoria
        if (Heater[i].state == 1) Heater[i].latch_error = 1;
        if (Heater[i].latch_error) (Heater[i].state == 1) ? Heater[i].state= 2 : Heater[i].state = 1; 
    }
}
//------------------------------------------------------------------------------
bool check_if_error()
{
    //return ERRORE 0 GOOD, 1 ERROR
    if (is_OT_controlled) for (int i=0; i< MAX_OT; i++) ERRORE = ERRORE || OT[i].state;
    if (is_Heater_controlled) for (int i=0; i< MAX_HEATER; i++) ERRORE = ERRORE || Heater[i].state;
    if (is_Analog_controlled) for (int i=0; i< MAX_ANALOG; i++) ERRORE = ERRORE || ANALOG[i].state;
    if (is_Digital_controlled) for (int i=0; i< MAX_DIGITAL; i++) ERRORE = ERRORE || DIGITAL[i].state;
    return ERRORE;
}
//------------------------------------------------------------------------------
void function_back_to_home_page(int back_home_ms)
{
    //funzione che ritorna a visualizzare pagina 0 dopo un tempo espresso in millisecondi
    (actual_sheet == 0 ) ? initial_time = timer.read_ms() : actual_time = timer.read_ms();
    if ( actual_time - initial_time > back_home_ms ) {
        actual_sheet = 0;
        display_draw_sheet(actual_sheet);
    }
}
//------------------------------------------------------------------------------
void function_zero_array()
{
    int a, b;
    for (a=0; a<MAX_HEATER; a++) { 
        for (b=0; b<MAX_Samples; b++) { 
            Heater_Samples[a][b] = 1;
        }
    b=0;
    }  
}
//------------------------------------------------------------------------------
void function_check_analog()
{
    for (int n=0; n< MAX_ANALOG; n++)
        {            
            ANALOG[n].average = 0;
            selectInput4051(n);
            wait_us(10);
            for (int a=0; a<3; a++)
                {
                ANALOG[n].average = ANALOG[n].average + analog_value.read();
                wait_us(5);
                }
            ANALOG[n].average = (ANALOG[n].average/3 - ANALOG[n].offset);
        if (ANALOG[n].average < ANALOG[n].limit) ANALOG[n].latch_error = 1;
        if (ANALOG[n].latch_error) (ANALOG[n].average < ANALOG[n].limit) ? ANALOG[n].state= 2 : ANALOG[n].state = 1; 
        }
}
//------------------------------------------------------------------------------
void function_print_analog()
{
    lcd.SetTextColor(black);
    for (int n=0; n< MAX_ANALOG; n++)
        {  
            sprintf((char*)text, "%2.2f", ANALOG[n].average);
            lcd.DisplayStringAt(180,LINE(2+n), (uint8_t *)&text, LEFT_MODE);
            (ANALOG[n].average > ANALOG[n].limit) ? lcd.SetTextColor(forestgreen) : lcd.SetTextColor(red);
            lcd.FillRect(260, LINE(2+n), 15, 15);
            lcd.SetTextColor(black);
        }
    lcd.SetTextColor(black);
}
//------------------------------------------------------------------------------
void function_check_digital()
{
    DIGITAL[0].average = digital_signal_1.read();
    //DIGITAL[1].average = digital_signal_2.read();
    for (int n=0; n< MAX_DIGITAL; n++)
        {            
            if (DIGITAL[n].average == 0) DIGITAL[n].latch_error = 1;
            if (DIGITAL[n].latch_error) (DIGITAL[n].average == 0) ? DIGITAL[n].state= 2 : DIGITAL[n].state = 1; 
        }
}
//------------------------------------------------------------------------------
void function_print_digital()
{
    for (int n=0; n< MAX_DIGITAL; n++)
        {  
            (DIGITAL[n].average > DIGITAL[n].limit) ? lcd.SetTextColor(forestgreen) : lcd.SetTextColor(red);
            lcd.FillRect(220, LINE(11+n), 15, 15);
        }
    lcd.SetTextColor(black);
}
#endif

