#ifndef DISPLAY_H
#define DISPLAY_H

////////////////////////////////////////////////////////////////////////////////
void display_Error(bool error)
{
    //visualizzazione della faccina felice/triste
    int X = 10;
    int Y = 10;
    int riga, colonna, contatore=0;
    for (colonna=0; colonna<220; colonna++)  {
        for ( riga=0; riga<400; riga++)  {
            if (error == 0) lcd.DrawPixel (X+riga, Y+colonna, _acError000[contatore]);
            else lcd.DrawPixel (X+riga, Y+colonna, _acError111[contatore]);
            contatore++;
        }
        riga=0;
    }
}
////////////////////////////////////////////////////////////////////////////////
void display_sfondo_macchina()
{
    int X = 150;
    int Y = 50;
    int riga, colonna, contatore=0;
    for (colonna=0; colonna<300; colonna++)  {
        for ( riga=0; riga<450; riga++)  {
             lcd.DrawPixel (X+riga, Y+colonna, _acsfondo[contatore]);
            contatore++;
        }
        riga=0;
    }
}
////////////////////////////////////////////////////////////////////////////////
void display_mini_state(int sensor_state, int X, int Y)
{
    //visualizzazione dello stato dei vari elementi, usato in pagina 0
    int riga, colonna, contatore=0;
    for (colonna=0; colonna<40; colonna++)  {
        for ( riga=0; riga<40; riga++)  {
            switch (sensor_state) {
                //----------------------------------------------------------
                case 0:
                    lcd.DrawPixel (X+riga, Y+colonna, _acqgreen[contatore]);
                    break;
                case 1:
                    lcd.DrawPixel (X+riga, Y+colonna, _acqredgreen[contatore]);
                    break;
                case 2:
                    lcd.DrawPixel (X+riga, Y+colonna, _acqred[contatore]);
                    break;
            }
            contatore++;
        }
        riga=0;
    }
    contatore=0;
}
////////////////////////////////////////////////////////////////////////////////
void display_OT_state(int sensor_state, int X, int Y, int MAXSensor)
{
    //visualizzazione degli stati degli OT, usato in pagina 1
    int riga, colonna, contatore=0;
    for (colonna=0; colonna<150; colonna++)  {
        for ( riga=0; riga<75; riga++)  {
            switch (sensor_state) {
                //----------------------------------------------------------
                case 0:
                    lcd.DrawPixel (X+riga, Y+colonna, _ac_on1[contatore]);
                    break;
                case 1:
                    lcd.DrawPixel (X+riga, Y+colonna, _ac_onoff1[contatore]);
                    break;
                case 2:
                    lcd.DrawPixel (X+riga, Y+colonna, _ac_off1[contatore]);
                    break;
            }
            contatore++;
        }
        riga=0;
    }
    contatore=0;

}
////////////////////////////////////////////////////////////////////////////////
void display_setup()
{
    //realizzazione del rettangolo di sfondo piu' la barra grigia nel riquadro inferiore del display
    lcd.Clear(BackColor);
    lcd.SetFont(&Font24);
    lcd.SetTextColor(gray);
    lcd.SetBackColor(BackColor);
    lcd.FillRect(0, 440, 800, 39);
    lcd.SetTextColor(black);
    lcd.SetBackColor(gray);
    lcd.DrawHLine(0, 410, 800);
    lcd.DrawHLine(0,440, 800);
    lcd.DrawVLine(160, 441, 39);
    lcd.DrawVLine(640, 441, 39);
    lcd.DisplayStringAt(0, 450, (uint8_t *)"Metal Controller - Ver 2.3", CENTER_MODE);
    lcd.DisplayStringAt(5, LINE(19)-5, (uint8_t *)"<< PREV", LEFT_MODE);
    lcd.DisplayStringAt(645, LINE(19)-5,  (uint8_t *)"NEXT >>", LEFT_MODE);
    lcd.SetBackColor(BackColor);
}
////////////////////////////////////////////////////////////////////////////////
void display_draw_sheet (int actual_sheet)
{
    //disegno delle singole pagine//////////////////////////////////////////////
    switch (actual_sheet) {
        //----------------------------------------------------------------------
        case 0: {                                                               //Disegno Pagina 0
            lcd.SetTextColor(BackColor);
            lcd.FillRect(0, 0, 800, 409);
            lcd.SetTextColor(black);
            if (is_OT_displayed) lcd.DisplayStringAt(430, 40, (uint8_t *)"Over Temperatures", LEFT_MODE);
            if (is_Heater_displayed) lcd.DisplayStringAt(430, 120, (uint8_t *)"Heaters", LEFT_MODE);
            if (is_Analog_displayed) lcd.DisplayStringAt(430, 200, (uint8_t *)"Analog Signals", LEFT_MODE);
            if (is_Digital_displayed) lcd.DisplayStringAt(430, 280, (uint8_t *)"Digital Signals", LEFT_MODE);
        }
        break;
        //----------------------------------------------------------------------
        case 1: {                                                               //Disegno Pagina 1
            lcd.SetTextColor(BackColor);
            lcd.FillRect(0, 0, 800, 409);
            lcd.SetTextColor(black);
            lcd.DisplayStringAt(35, 35, (uint8_t *)"Over Temperatures:", LEFT_MODE);
        }
        break;
        //----------------------------------------------------------------------
        case 2: {                                                               //Disegno Pagina 2
            lcd.SetTextColor(BackColor);
            lcd.FillRect(0, 0, 800, 409);
            lcd.SetTextColor(black);
            for (int riga=0; riga<MAX_HEATER; riga++) {
                lcd.DisplayStringAt(10, LINE(1+2*riga), (uint8_t *)"Heater  :", LEFT_MODE);
                //lcd.DisplayStringAt(10, LINE(7+2*riga), (uint8_t *)"Calibration  :", LEFT_MODE);
                sprintf((char*)text, "%d", riga+1);
                lcd.DisplayStringAt(120,LINE(1+2*riga), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "%2.3f", Heater[riga].limit);
                lcd.DisplayStringAt(660,LINE(1+2*riga), (uint8_t *)&text, LEFT_MODE);
                //lcd.DisplayStringAt(210,LINE(7+2*riga), (uint8_t *)&text, LEFT_MODE);
                //sprintf((char*)text, "%2.3f", Heater[riga].offset);
                //lcd.DisplayStringAt(250,LINE(7+2*riga), (uint8_t *)&text, LEFT_MODE); 
            }
        }
        break;
        //------------------------------------------------------------------
        case 3: {                                                               //Disegno Pagina 3
            lcd.SetTextColor(BackColor);
            lcd.FillRect(0, 0, 800, 409);
            lcd.SetTextColor(black);
            lcd.DisplayStringAt(10, LINE(1), (uint8_t *)"Analog Signals", CENTER_MODE);
            lcd.DisplayStringAt(10, LINE(2), (uint8_t *)"BCl3  :", LEFT_MODE);
            lcd.DisplayStringAt(10, LINE(3), (uint8_t *)"gas2  :", LEFT_MODE);
            lcd.DisplayStringAt(10, LINE(4), (uint8_t *)"gas3  :", LEFT_MODE);
            lcd.DisplayStringAt(10, LINE(5), (uint8_t *)"gas4  :", LEFT_MODE);
            lcd.DisplayStringAt(10, LINE(6), (uint8_t *)"gas5  :", LEFT_MODE);
            lcd.DisplayStringAt(10, LINE(7), (uint8_t *)"gas6  :", LEFT_MODE);
            lcd.DisplayStringAt(10, LINE(8), (uint8_t *)"gas7  :", LEFT_MODE);
            lcd.DisplayStringAt(10, LINE(9), (uint8_t *)"gas8  :", LEFT_MODE);
            lcd.DisplayStringAt(10, LINE(10), (uint8_t *)"Digital Signals", CENTER_MODE);
            lcd.DisplayStringAt(10, LINE(11), (uint8_t *)"dig1      :", LEFT_MODE);
            lcd.DisplayStringAt(10, LINE(12), (uint8_t *)"dig2      :", LEFT_MODE);
            lcd.DisplayStringAt(10, LINE(13), (uint8_t *)"dig3      :", LEFT_MODE);
            
        }
        break;
        //----------------------------------------------------------------------
        case 4: {                                                               //Disegno Pagina 4
            lcd.SetTextColor(BackColor);
            lcd.FillRect(0, 0, 800, 409);
            lcd.SetTextColor(black);
            lcd.DisplayStringAt(5, LINE(3), (uint8_t *)"OT display", LEFT_MODE);
            lcd.DisplayStringAt(5, LINE(4), (uint8_t *)"OT control", LEFT_MODE);
            lcd.DisplayStringAt(5, LINE(5), (uint8_t *)"Heater display", LEFT_MODE);
            lcd.DisplayStringAt(5, LINE(6), (uint8_t *)"Heater control", LEFT_MODE); 
            lcd.DisplayStringAt(5, LINE(7), (uint8_t *)"Analog display", LEFT_MODE);
            lcd.DisplayStringAt(5, LINE(8), (uint8_t *)"Analog control", LEFT_MODE);   
            lcd.DisplayStringAt(5, LINE(9), (uint8_t *)"Digital display", LEFT_MODE);
            lcd.DisplayStringAt(5, LINE(10), (uint8_t *)"Digital control", LEFT_MODE); 
            (is_OT_displayed) ? lcd.DisplayStringAt(350, LINE(3), (uint8_t *)"ACTIVE", LEFT_MODE) : lcd.DisplayStringAt(350, LINE(3), (uint8_t *)"NOT ACTIVE", LEFT_MODE);
            (is_OT_controlled) ? lcd.DisplayStringAt(350, LINE(4), (uint8_t *)"ACTIVE", LEFT_MODE) : lcd.DisplayStringAt(350, LINE(4), (uint8_t *)"NOT ACTIVE", LEFT_MODE);
            (is_Heater_displayed) ? lcd.DisplayStringAt(350, LINE(5), (uint8_t *)"ACTIVE", LEFT_MODE) : lcd.DisplayStringAt(350, LINE(5), (uint8_t *)"NOT ACTIVE", LEFT_MODE);
            (is_Heater_controlled) ? lcd.DisplayStringAt(350, LINE(6), (uint8_t *)"ACTIVE", LEFT_MODE) : lcd.DisplayStringAt(350, LINE(6), (uint8_t *)"NOT ACTIVE", LEFT_MODE);
            (is_Analog_displayed) ? lcd.DisplayStringAt(350, LINE(7), (uint8_t *)"ACTIVE", LEFT_MODE) : lcd.DisplayStringAt(350, LINE(7), (uint8_t *)"NOT ACTIVE", LEFT_MODE);
            (is_Analog_controlled) ? lcd.DisplayStringAt(350, LINE(8), (uint8_t *)"ACTIVE", LEFT_MODE) : lcd.DisplayStringAt(350, LINE(8), (uint8_t *)"NOT ACTIVE", LEFT_MODE);
            (is_Digital_displayed) ? lcd.DisplayStringAt(350, LINE(9), (uint8_t *)"ACTIVE", LEFT_MODE) : lcd.DisplayStringAt(350, LINE(9), (uint8_t *)"NOT ACTIVE", LEFT_MODE);
            (is_Digital_controlled) ? lcd.DisplayStringAt(350, LINE(10), (uint8_t *)"ACTIVE", LEFT_MODE) : lcd.DisplayStringAt(350, LINE(10), (uint8_t *)"NOT ACTIVE", LEFT_MODE);
          
        }
        break;
        //----------------------------------------------------------------------
    }
}
////////////////////////////////////////////////////////////////////////////////
void display_sheet_number()
{
    //visualizza il numero della pagina attuale sul display in basso a sinistra
    sprintf((char*)text, "%d", actual_sheet);
    lcd.DisplayStringAt(10,415, (uint8_t *)&text, LEFT_MODE);
}
////////////////////////////////////////////////////////////////////////////////

#endif




