#ifndef _CONFIG
#define _CONFIG

#include "TS_DISCO_F469NI.h"
#include "LCD_DISCO_F469NI.h"
#include "lib4051.h"
#include <time.h>

#define HIGH 1
#define LOW 0

LCD_DISCO_F469NI lcd;
TS_DISCO_F469NI ts;
TS_StateTypeDef TS_State;
Timer timer;
int initial_time, actual_time;

/*
const int baudrate = 19200;
Serial pc(SERIAL_TX, SERIAL_RX, baudrate);
*/
uint8_t status;
uint8_t cleared = 0;
uint8_t prev_nb_touches = 0;
uint8_t text[30];

//////////////////////////////////////////////////////////////////////////////// 
//// attivazione visualizzazione, controlli dei vari elementi///////////////////
const bool is_OT_displayed = 1;
const bool is_OT_controlled = 1;                    //**
const bool is_Heater_displayed = 1; 
const bool is_Heater_controlled = 0;                //**
const bool is_Analog_displayed = 1;   
const bool is_Analog_controlled = 0;                //**
const bool is_Digital_displayed = 1; 
const bool is_Digital_controlled = 0;

////////////////////////////////////////////////////////////////////////////////                              
/// PIN DECLARATION  ///////////////////////////////////////////////////////////
DigitalOut Relay_Error1 (D2);
DigitalOut Relay_Error2 (D3);
DigitalIn digital_signal_1(D11); /***** da controllare pin *****/

//pinout for CD4021
DigitalOut clockPin(D8);            //CLCK  pin 10      DON'T TOUCH
DigitalOut latchPin(D9);            //PS/C  pin 9       DON'T TOUCH
DigitalIn  dataPin(D10);            //Q8    pin 3       DON'T TOUCH

AnalogIn signalHeater1 (A0);
AnalogIn signalHeater2 (A1);
AnalogIn signal_03(A2);

//pinout per CD4051, switch analogico
AnalogIn analog_value(A3);          //                  DON'T TOUCH   

//////////////////////////////////////////////////////////////////////////////// 
/// dichiarazione variabili ////////////////////////////////////////////////////
int actual_sheet = 0;
int total_sheet = 5;
bool ERRORE = 0;

struct signal {
    int state;                      //stato della variabile, OK, OK con errore in precedenza, errore
    float average;                  //valore medio, 
    bool latch_error;               //memoria dell' errore
    const float limit;              //limite da impostare sotto il quale segnala errore
    float offset;
    bool ON_OFF;
    }; 
////////////////////////////////////////////////////////////////////////////////
const int MAX_BCl3 = 1;    
signal  BCl3 = { 0, 0, 0, 0.01, 0, 0};
////////////////////////////////////////////////////////////////////////////////
const int MAX_OT = 8;  
signal OT[MAX_OT] = { {0, 0, 0, 0, 0, 0}, 
                      {0, 0, 0, 0, 0, 0}, 
                      {0, 0, 0, 0, 0, 0},    
                      {0, 0, 0, 0, 0, 0}, 
                      {0, 0, 0, 0, 0, 0},  
                      {0, 0, 0, 0, 0, 0}, 
                      {0, 0, 0, 0, 0, 0}, 
                      {0, 0, 0, 0, 0, 0} }; 
////////////////////////////////////////////////////////////////////////////////                      
const int MAX_ANALOG = 1;  
signal ANALOG[MAX_ANALOG] = {   {0, 0, 0, 0.1, 0, 0}}; 
                                //{0, 0, 0, 0.1, 0, 0}, 
                                //{0, 0, 0, 0.1, 0, 0},    
                                //{0, 0, 0, 0.1, 0, 0}, 
                                //{0, 0, 0, 0.1, 0, 0},  
                                //{0, 0, 0, 0.1, 0, 0}, 
                                //{0, 0, 0, 0.1, 0, 0}, 
                                //{0, 0, 0, 0.1, 0, 0} }; 
////////////////////////////////////////////////////////////////////////////////                          
const int MAX_DIGITAL = 1;
signal DIGITAL[MAX_DIGITAL] = { {0, 0, 0, 0.05, 0, 0} }; 
                              //{0, 0, 0, 0.05, 0, 0} }; 
////////////////////////////////////////////////////////////////////////////////                          
const int MAX_HEATER = 2;
signal Heater[MAX_HEATER] = { {0, 0, 0, 0.03, 0, 0}, 
                              {0, 0, 0, 0.03, 0, 0} };  
//per gli heater, per creare array circolare
int Sample = 0;
const int MAX_Samples = 300;
bool Heater_Samples[MAX_HEATER][MAX_Samples];
int heater_actual_time;     

#endif




