#include "mbed.h"

#include "pictures.h"
#include "config.h"
#include "display.h"
#include "functions.h"

int main()
{
    timer.start();
    function_zero_array();
    display_setup();
    display_draw_sheet(actual_sheet);

    //configuro lo switch analogico
    config4051(D6, D5, D4);

    while(1) {
        
        //acquisisco la pressione sullo schermo per attivare i vari oggetti/////
        ts.GetState(&TS_State);
        ////////////////////////////////////////////////////////////////////////
        
        // se premo nella barra inferiore cambio foglio/////////////////////////
        function_PREV_NEXT();
        ////////////////////////////////////////////////////////////////////////

        //comandi dei tasti nei vari fogli//////////////////////////////////////

        //se è attivo FOGLIO_0 /////////////////////////////////////////////////
        if (actual_sheet == 0) {
            display_Error(ERRORE);
            if (is_OT_displayed)
                for (int i=0; i<MAX_OT; i++) {
                    display_mini_state(OT[i].state, 430+40*i, 60);                  //overtemperatures
                }
            if (is_Heater_displayed)
                for (int i=0; i<MAX_HEATER; i++) {
                    display_mini_state(Heater[i].state, 430+40*i, 140);             //heaters
                }
            if (is_Analog_displayed) 
                for (int i=0; i<MAX_ANALOG; i++) {
                    display_mini_state(ANALOG[i].state, 430+40*i, 220);             //analog signals
                }
            if (is_Digital_displayed) 
                for (int i=0; i<MAX_DIGITAL; i++) {
                    display_mini_state(DIGITAL[i].state, 430+40*i, 300);            //digital signals
                }
        }
        //fine FOGLIO_0/////////////////////////////////////////////////////////

        //se è attivo FOGLIO_1 /////////////////////////////////////////////////
        if (actual_sheet == 1) {
            for (int i=0; i<MAX_OT; i++) {
                display_OT_state(OT[i].state, 35+i*95, 60, 8);
                print_OT_alarmed();
            }
            //for (int pi = 0; pi<8; pi++) lcd.DrawRect(35+pi*95, 60, 95, 150);
            if ( (TS_State.touchDetected) && (TS_State.touchX[0]>35 && TS_State.touchX[0]<795 && TS_State.touchY[0]>60 && TS_State.touchY[0]<210) && 
                        OT[(TS_State.touchX[0] - 35)/95].latch_error > 0) {
                //mostra la foto per 5 secondi
                lcd.SetTextColor(BackColor);
                lcd.FillRect(0, 0, 800, 409);
                lcd.SetTextColor(black);
                //qui da mettere il display foto
                display_sfondo_macchina();
                wait (4);
                display_setup();
                display_draw_sheet(actual_sheet);
            }

        }
        //fine FOGLIO_1/////////////////////////////////////////////////////////

        //se è attivo FOGLIO_2 /////////////////////////////////////////////////
        if (actual_sheet == 2) {
            for (int i=0; i<MAX_HEATER; i++) {       
                lcd.SetTextColor(black);  
                sprintf((char*)text, "%2.3f", Heater[i].average);
                lcd.DisplayStringAt(180,LINE(1+2*i), (uint8_t *)&text, LEFT_MODE);
                //if Heater is active = 1, small green square, else red
                (Heater[i].ON_OFF == 1) ? lcd.SetTextColor(forestgreen) : lcd.SetTextColor(red);
                lcd.FillRect(280, LINE(1+2*i), 15, 15);
            }   
            lcd.SetTextColor(BackColor);
            lcd.FillRect(300, 18, 1*MAX_Samples, 75);
            lcd.SetTextColor(black);
            for (int i=0; i<MAX_HEATER; i++) {
                int a_samples = 0;       
                for (a_samples=0; a_samples<MAX_Samples; a_samples++) {
                    lcd.FillRect(300+1*a_samples, LINE(1+2*i), 1, (10*Heater_Samples[i][a_samples]+1) );
                }
                a_samples=0;
            }         
        }
        //fine FOGLIO_2/////////////////////////////////////////////////////////

        //se è attivo FOGLIO_3 /////////////////////////////////////////////////
        if (actual_sheet == 3) {
            function_print_analog();
            function_print_digital();
        }
        //fine FOGLIO_3/////////////////////////////////////////////////////////
        
        //se è attivo FOGLIO_4 /////////////////////////////////////////////////
        if (actual_sheet == 4) {
                     
        }
        //fine FOGLIO_4/////////////////////////////////////////////////////////

        //CONTROLLI COMPONENTI//////////////////////////////////////////////////
        //OVER TEMPERATURES
        function_check_OT();
        //controllo dello stato degli heater, fatto ogni 3000 msec
        //numero di campioni costante di 300 -> con intervallo 1 secondo -> 5 minuti, 
        //numero di campioni costante di 300 -> con intervallo 3 secondi -> 15 minuti //se l' heater non scalda per 15 minuti viene dichiarato ERROR 
        //HEATERS
        if ( (timer.read_ms() - heater_actual_time) > 3000) {
            function_check_heaters(Sample);
            heater_actual_time = timer.read_ms();
            Sample++;
            if (Sample >= MAX_Samples) Sample = 0;
        }
        //ANALOG SIGNALS
        function_check_analog();
        //DIGITAL SIGNALS
        function_check_digital();
        ////////////////////////////////////////////////////////////////////////
        
        //BACK HOME PAGE////////////////////////////////////////////////////////
        //visualizza la pagina 0, in milliseconds (360000=6 minutes)
        function_back_to_home_page(360000);                                     
        display_sheet_number();
        ////////////////////////////////////////////////////////////////////////
        
        //CONTROL ERROR/////////////////////////////////////////////////////////
        //se check_if_error == 1, c'e' l'errore e il relay e' LOW (chiuso)
        //attiva/disattiva il relay 
        
        if (check_if_error())  Relay_Error1 = LOW;                              
        else  Relay_Error1 = HIGH; 
        ////////////////////////////////////////////////////////////////////////
        
        wait(0.1);
    }
}


