#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "OverTemp.h"
#include "colors.c"
#include "AL96OTPICTURE.c"

extern  LCD_DISCO_F746NG lcd;
extern  TS_DISCO_F746NG ts;
extern  TS_StateTypeDef TS_State;
extern  uint8_t text[30]; 
      
OverTemp sensore[7];

const int Ycerchio=35;
DigitalOut activeRelay (D2);      
bool ERRORE=0;
static bool myDataIn[8] = {1,0,1,0,1,0,1,0};


bool * getData()
{   //define where your pins are
    DigitalOut latchPin(D5);
    DigitalOut clockPin(D6);
    DigitalIn  dataPin(D7); 
    float tempoattesa = 20;              
    //acquiring values
    latchPin.write(1);
    wait_us(tempoattesa);  
    //read values acquired and store in array     
    latchPin.write(0);
    for (int i=7; i>=0; i--) 
    {
        wait_us(tempoattesa);
        clockPin.write(0);
        wait_us(tempoattesa);
        myDataIn[i] = dataPin.read();      //1 if OT open, 0 if OT close
        clockPin.write(1);
    }
    return myDataIn;
}

void INIZIALIZZAZIONE()
{//inizializzazione dello stato degli OT
 //lettura dello stato, e disegno a pannello
 for (int i=0; i<7; i++)                     
    {   
    sensore[i].State=*(getData()+i); 
    sensore[i].Tripped=0; 
    sensore[i].wasActive = *(getData()+i);  
    sensore[i].DrawCircle(50+65*i, Ycerchio, sensore[i].State);
    }
}

void DRAW(){
//Disegna l'immagine di sfondo
lcd.Clear(lightskyblue);
int riga, colonna;
unsigned long contatore=0;
for (riga=480; riga>0; riga--)  {
    for ( colonna=0; colonna<480; colonna++)  {   
        lcd.DrawPixel (colonna, 480-riga, _acAL96OTPICTURE[contatore]);
        contatore++;
        }
    colonna=0;
    }
}


int main() { 
lcd.Clear(lightskyblue);
INIZIALIZZAZIONE();

while(1)                                    
    {
        for (int i=0; i<7; i++)
        {
    //acquisisco lo stato degli OT, in caso di faulty .Tripped viene messo a 1    
        sensore[i].isActive = *(getData()+i);
        if (sensore[i].isActive==1) sensore[i].Tripped=1;
    //se lo stato dell'OT è cambiato rispetto lo stato precedente ne ridisegno il cerchio
        if (sensore[i].isActive!=sensore[i].wasActive) { 
            if (sensore[i].isActive==1)  sensore[i].State=1;                                    //rosso
            if ((sensore[i].isActive==0) && sensore[i].Tripped==0) sensore[i].State=0;          //verde
            if ((sensore[i].isActive==0) && sensore[i].Tripped==1) sensore[i].State=2;          //verderosso
            sensore[i].DrawCircle(50+65*i, Ycerchio, sensore[i].State);
            }
    //sono sotto un ciclo for, se almeno uno OT è andato in errore viene segnalato
        ERRORE = ERRORE || sensore[i].Tripped;
        if ( ERRORE ) {   
            lcd.SetFont(&Font24);
            lcd.SetTextColor(red);
            lcd.DrawRect(120, 73, 240, 35);
            lcd.DisplayStringAt(0, LINE(4)-17, (uint8_t *)" E R R O R ", CENTER_MODE);
            if (sensore[i].Tripped) sensore[i].Write(i);
            //qui da mettere il relay 
            activeRelay.write(0);
            }
        else {   
            lcd.SetFont(&Font24);
            lcd.SetTextColor(lime);
            lcd.DrawRect(120, 73, 240, 35);
            lcd.DisplayStringAt(0, LINE(4)-17, (uint8_t *)" O K ", CENTER_MODE);
            //qui da mettere il relay
            activeRelay.write(1);
            }
    
        if ( sensore[i].isTouched(50+65*i, Ycerchio) && (sensore[i].Tripped) )  
            { 
            DRAW();
            sensore[i].DrawOTPosition(i);
            wait(6);
            lcd.Clear(lightskyblue);
            for (int i=0; i<7; i++) {sensore[i].DrawCircle(50+65*i, Ycerchio, sensore[i].State); }
            } 
   
        sensore[i].wasActive = sensore[i].isActive;           
        }       
        wait(0.1); 
    }//close while(1)
}//close main
