#include "OverTemp.h"

  LCD_DISCO_F746NG lcd;
  TS_DISCO_F746NG ts;
  TS_StateTypeDef TS_State;
     uint16_t x, y;
     uint8_t idx;
     uint8_t status;
     uint8_t cleared = 0;
     uint8_t prev_nb_touches = 0;
     uint8_t text[30]; 

void OverTemp::DrawCircle(int X, int Y, int State)
{//disegna un cerchio colorato in maniera differente per indicare lo stato dell'OT
    lcd.SetBackColor(lightskyblue);
    lcd.SetTextColor(black);
    lcd.DrawCircle(X, Y, Raggio);
    lcd.DrawCircle(X, Y, Raggio-1);
    switch (State)
    {
        case (0):       //verde
                {    
                lcd.SetTextColor(green);
                lcd.FillCircle(X, Y, Raggio-2);
                break;
                }
        case (1):       //rosso
                {
                lcd.SetTextColor(red);
                lcd.FillCircle(X, Y, Raggio-2);
                break;
                }
        case (2):       //verde con pallino rosso
                {
                lcd.SetTextColor(green);
                lcd.FillCircle(X, Y, Raggio-2);
                lcd.SetTextColor(red);
                lcd.FillCircle(X, Y, Raggio-15);
                break;
                }
        default:
                {
                lcd.SetTextColor(blue);
                lcd.FillCircle(X, Y, Raggio-2);
                break;
                }
    }                               
}

void OverTemp::Write(int digit)
{
    lcd.SetFont(&Font20);
    lcd.SetTextColor(black);
    switch(digit)
        {                
        case (0):{lcd.DisplayStringAt(0, LINE(6+digit), (uint8_t *)"Lower chamber ZONE 1", LEFT_MODE); break;}
        case (1):{lcd.DisplayStringAt(0, LINE(6+digit), (uint8_t *)"Lower chamber ZONE 2", LEFT_MODE); break;}
        case (2):{lcd.DisplayStringAt(0, LINE(6+digit), (uint8_t *)"Upper chamber", LEFT_MODE); break;}
        case (3):{lcd.DisplayStringAt(0, LINE(6+digit), (uint8_t *)"End Point Window", LEFT_MODE); break;}
        case (4):{lcd.DisplayStringAt(0, LINE(6+digit), (uint8_t *)"Slit Valve", LEFT_MODE); break;}
        case (5):{lcd.DisplayStringAt(0, LINE(6+digit), (uint8_t *)"Shorted", LEFT_MODE); break;}
        case (6):{lcd.DisplayStringAt(0, LINE(6+digit), (uint8_t *)"Lower transition manifold", LEFT_MODE); break;}
        case (7):{lcd.DisplayStringAt(0, LINE(6+digit), (uint8_t *)" prova canale 7 ", LEFT_MODE); break;}
        }            

}

bool OverTemp::isTouched(int X, int Y)
{//se è premuto ritorna 1, altrimento 0
bool Touch;
int Xpressed, Ypressed;
ts.ResetTouchData(&TS_State);   
ts.GetState(&TS_State);      
Xpressed = TS_State.touchX[0];                             //acquisisco la X 
Ypressed = TS_State.touchY[0];                             //acquisisco la Y
if ( !((Xpressed>X-Raggio &&  Xpressed<X+Raggio) && (Ypressed>Y-Raggio && Ypressed<Y+Raggio)) )  Touch=0;
    else Touch=1;
ts.ResetTouchData(&TS_State);  
return Touch;
}

void OverTemp::DrawOTPosition(int digit){
lcd.SetTextColor(red);
switch (digit)
    {
        case (0):       //Lower chamber ZONE 1
                {
                lcd.DrawRect(5, 50, 190, 25);
                lcd.DrawEllipse(345, 170, 60, 20); 
                lcd.DrawEllipse(345, 170, 61, 21);   
                break;
                }
        case (1):       //Lower chamber ZONE 2
                {
                lcd.DrawRect(5, 85, 190, 25); 
                lcd.DrawEllipse(385, 190, 60, 20); 
                lcd.DrawEllipse(385, 190, 61, 21); 
                break;
                }
        case (2):       //Upper chamber
                {
                lcd.DrawRect(5, 113, 190, 25); 
                lcd.DrawEllipse(365, 70, 60, 20); 
                lcd.DrawEllipse(365, 70, 61, 21);  
                break;
                }
        case (3):       //End Point Window
                {
                lcd.DrawRect(5, 145, 190, 25); 
                lcd.DrawEllipse(400, 162, 40, 20); 
                lcd.DrawEllipse(400, 162, 41, 21);      
                break;
                }
        case (4):       //Slit Valve
                {
                lcd.DrawRect(5, 174, 190, 25); 
                lcd.DrawEllipse(265, 230, 40, 20); 
                lcd.DrawEllipse(265, 230, 41, 21);   
                break;
                }
        case (5):       //Shorted
                {
                lcd.DrawRect(5, 204, 190, 25);  
                break;
                }
        case (6):       //Lower transition manifold
                {
                lcd.DrawRect(5, 232, 190, 25);
                lcd.DrawEllipse(280, 120, 40, 20); 
                lcd.DrawEllipse(280, 120, 41, 21);  
                break;
                }
        case (7):       //prova canale 7
                {
                lcd.DrawRect(5, 5, 190, 5);  
                break;
                }
    }
}
