/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: Target board general functions implementation

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __BOARD_H__
#define __BOARD_H__

#include "Config.h"
#include "mbed.h"
#include "system/timer.h"
#include "debug.h"
#include "system/utilities.h"
#include "sx1272-hal.h"
#include "gps.h"
#include "mpl3115a2.h"
#include "mma8451q.h"

/*!
 * Unique Devices IDs register set ( STM32L1xxx )
 */
#define         ID1                                 ( 0x1FF800D0 )
#define         ID2                                 ( 0x1FF800D4 )
#define         ID3                                 ( 0x1FF800E4 )

#define LOW_BAT_THRESHOLD   3.45

extern DigitalOut RedLed;
extern DigitalOut GreenLed;
extern DigitalOut YellowLed;
extern DigitalOut UsrLed;
extern GPS Gps;
extern MPL3115A2 Mpl3115a2;
extern MMA8451Q Mma8451q;

extern DigitalIn PC0; // Used for Push button application demo

extern SX1272MB2xAS Radio;

typedef enum
{
    MOTE_VERSION_NONE = 0,
    MOTE_VERSION_2,
    MOTE_VERSION_3,
}MoteVersion_t;


/*!
 * \brief Initializes the target board peripherals.
 */
void BoardInit( void );

/*!
 * \brief Measure the Battery level
 *
 * \retval value  battery level ( 0: very low, 254: fully charged )
 */
uint8_t BoardGetBatteryLevel( void );

/*!
 * \brief Measure the Battery voltage
 *
 * \retval value  battery voltage in volts
 */
float BoardGetBatteryVoltage( void );

/*!
 * Returns a pseudo random seed generated using the MCU Unique ID
 *
 * \retval seed Generated pseudo random seed
 */
uint32_t BoardGetRandomSeed( void );

/*!
 * \brief Generates Lower 32 bits of DEVEUI using 96 bits unique device ID 
 *
 * \param [IN] id Pointer to an array that will contain the Unique ID
 */
void BoardGetDevEUI( uint8_t *id );

/*!
 * \brief Gets the board 64 bits unique ID 
 *
 * \param [IN] id Pointer to an array that will contain the Unique ID
 */
void BoardGetUniqueId( uint8_t *id );

#endif // __BOARD_H__
