/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: VT100 serial display management

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/

#include "SerialDisplay.h"
extern int do_high_power;
extern int Force_channel;
extern uint8_t Hard_channel;
extern uint8_t Channel;

VT100 vt( USBTX, USBRX );

void SerialDisplayJoinUpdate( void )
{
    printf( "###### ===== JOINING ==== ######\r\n" );
    
    DisplayNetworkParam( );
    printf ("Channel = %d \r\n", Channel);

    printf( "\r\n" );
}
extern int verbose;
int TX_first_time = 1;
int total_sends;
int delta;
int old_delta;

void SerialDisplayTxUpdate(void)
{
    delta = total_sends - LoRaMacUplinkStatus.UplinkCounter;
    printf( "#UF %d ==== delta = %d # ", LoRaMacUplinkStatus.UplinkCounter, delta  );
    if (old_delta != delta)
    {
        old_delta = delta;
        printf( "######                                         new  delta = %d##\r\n", delta );
        
    }
    DisplayNetworkParam( );

    if ((verbose > 10) || TX_first_time)
    {    
        TX_first_time = 0;
        printf( "TX PORT: %d\r\n", LoRaMacUplinkStatus.Port );

        if( LoRaMacUplinkStatus.BufferSize != 0 )
        {
            printf( "TX DATA: " );
            if( LoRaMacUplinkStatus.Type == MCPS_CONFIRMED )
            {
                printf( "CONFIRMED\r\n" );
            }
            else
            {
                printf( "UNCONFIRMED\r\n" );
            }
            SerialDisplayHex( LoRaMacUplinkStatus.Buffer, LoRaMacUplinkStatus.BufferSize );
        }

        printf( "DATA RATE: DR%d\r\n", LoRaMacUplinkStatus.Datarate );
    
        printf( "BATTERY: %2.2fV\r\n", BoardGetBatteryVoltage( ) );

    }
    if (do_high_power)
    {
        printf( "TX P %d ", 30  );
    }
    else
    {
        printf( "TX P %d ", 30 - ( LoRaMacUplinkStatus.TxPower << 1 ) );
    }
    if  (Force_channel)
    {
        printf("Tot S = %d ", total_sends );
    }
    else
    {
        printf("channel number %d, total sends = %d \r\n", Channel, total_sends);
    }
    if (verbose > 5)
        printf( "\r\n");
}

int RX_first_time = 1;

void SerialDisplayRxUpdate( void )
{
    printf( "# DF %d ==== ###### ", LoRaMacDownlinkStatus.DownlinkCounter );
    printf( "W %d", LoRaMacDownlinkStatus.RxSlot + 1 );

    if ((verbose > 10) || (RX_first_time))
    {
        RX_first_time = 0;
    
        printf( "RX PORT: %d\r\n", LoRaMacDownlinkStatus.Port );

        if( LoRaMacDownlinkStatus.BufferSize != 0 )
        {
            printf( "RX DATA: \r\n" );
            SerialDisplayHex( LoRaMacDownlinkStatus.Buffer, LoRaMacDownlinkStatus.BufferSize );
        }

        printf( "RX RSSI: %d\r\n", LoRaMacDownlinkStatus.Rssi );

        printf( "RX SNR: %d\r\n", LoRaMacDownlinkStatus.Snr );

        printf( "\r\n" );
    }
}

void SerialDisplayHex( uint8_t *pData, uint8_t len )
{
    int i;
    bool newline = 0;

    for( i = 0; i < len; i++ )
    {
        if( newline != 0 )
        {
            printf( "\r\n" );
            newline = 0;
        }

        printf( "%02X ", pData[i] );

        if( ( ( i + 1 ) % 16 ) == 0 )
        {
            newline = 1;
        }
    }
    printf( "\r\n" );
}

void SerialAcclMetrDisplay( uint8_t statusReg )
{
    if (verbose > 9)
        printf( "===== DEVICE ORIENTATION ====\r\n" );
    if( ( statusReg & 0x40 ) != 0 )
    {
        printf( "H + " );
        if( ( statusReg & 0x01 ) != 0 )
        {
            do_high_power = 1;
            Force_channel = 1;
            printf( "FD=highP,ForceC " );
        }
        else
        {
            do_high_power=0;
            Force_channel = 1;
            printf( "FU=ForcC " );
        }
    }
    else
    {
        do_high_power = 0;
        Force_channel = 0;
        printf( "VERTICAL - regular power, regular channel" ); 
    }
    //printf( "\r\n\r\n" );
}
int first_time = 1;
int verbose = 1;

void DisplayNetworkParam( void )
{
    if ((verbose > 10) || (first_time))
    {
        first_time = 0;
#if( OVER_THE_AIR_ACTIVATION != 0 )

    printf( "DEVEUI: " );
    SerialDisplayHex( DevEui, 8 );

    printf( "APPEUI: " );
    SerialDisplayHex( AppEui, 8 );

    printf( "APPKEY: " );
    SerialDisplayHex( AppKey, 16 );

#else

    printf( "DEVADDR: " );
    
    uint8_t *pData = ( uint8_t* )&DevAddr;
    for( int32_t i = 3; i >= 0; i-- )
    {
        printf( "%02X ", pData[i] );
    }
    printf( "\r\n" );

    printf( "NWKSKEY: " );
    SerialDisplayHex( NwkSKey, 16 );

    printf( "APPSKEY: " );
    printf( " channel = %d\r\n", Channel);
    SerialDisplayHex( AppSKey, 16 );

#endif
    }
}