/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: MAC Layer Services: MLME & MCPS

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Uttam Bhat
*/

#include "LoRaMacLayerService.h"

/*!
 * \brief   MCPS-Confirm event function
 *
 * \param   [IN] McpsConfirm - Pointer to the confirm structure,
 *               containing confirm attributes.
 */
void McpsConfirm( McpsConfirm_t *McpsConfirm )
{
    if( McpsConfirm->Status == LORAMAC_EVENT_INFO_STATUS_OK )
    {
        switch( McpsConfirm->McpsRequest )
        {
            case MCPS_UNCONFIRMED:
            {
                // Check Datarate
                // Check TxPower
                break;
            }
            case MCPS_CONFIRMED:
            {
                // Check Datarate
                // Check TxPower
                // Check AckReceived
                // Check NbRetries
                LoRaMacUplinkStatus.Acked = McpsConfirm->AckReceived;
                break;
            }
            case MCPS_PROPRIETARY:
            {
                break;
            }
            default:
                break;
        }        
    }

    LoRaMacUplinkStatus.Datarate = McpsConfirm->Datarate;
    LoRaMacUplinkStatus.UplinkCounter = McpsConfirm->UpLinkCounter;
    LoRaMacUplinkStatus.TxPower = McpsConfirm->TxPower;

    IsTxIntUpdate = true;
}

/*!
 * \brief   MCPS-Indication event function
 *
 * \param   [IN] McpsIndication - Pointer to the indication structure,
 *               containing indication attributes.
 */
void McpsIndication( McpsIndication_t *McpsIndication )
{
    uint8_t port;
    
    Gps.service( );

    if( McpsIndication->Status != LORAMAC_EVENT_INFO_STATUS_OK )
    {
        return;
    }

    switch( McpsIndication->McpsIndication )
    {
        case MCPS_UNCONFIRMED:
        {
            break;
        }
        case MCPS_CONFIRMED:
        {
            break;
        }
        case MCPS_PROPRIETARY:
        {
            break;
        }
        case MCPS_MULTICAST:
        {
            break;
        }
        default:
            break;
    }

    // Check Multicast
    // Check Port
    // Check Datarate
    // Check FramePending
    // Check Buffer
    // Check BufferSize
    // Check Rssi
    // Check Snr
    // Check RxSlot
    LoRaMacDownlinkStatus.Rssi = McpsIndication->Rssi;
    if( McpsIndication->Snr & 0x80 ) // The SNR sign bit is 1
    {
        // Invert and divide by 4
        LoRaMacDownlinkStatus.Snr = ( ( ~McpsIndication->Snr + 1 ) & 0xFF ) >> 2;
        LoRaMacDownlinkStatus.Snr = -LoRaMacDownlinkStatus.Snr;
    }
    else
    {
        // Divide by 4
        LoRaMacDownlinkStatus.Snr = ( McpsIndication->Snr & 0xFF ) >> 2;
    }
    LoRaMacDownlinkStatus.DownlinkCounter++;
    LoRaMacDownlinkStatus.RxData = McpsIndication->RxData;      
    LoRaMacDownlinkStatus.Port = McpsIndication->Port;
    LoRaMacDownlinkStatus.Buffer = McpsIndication->Buffer;
    LoRaMacDownlinkStatus.BufferSize = McpsIndication->BufferSize;
    LoRaMacDownlinkStatus.RxSlot = McpsIndication->RxSlot;

    if( ComplianceTest.Running == 1 )
    {
        port = 224;
        ComplianceTest.DownLinkCounter++;
    }
    else
    {
        port = McpsIndication->Port;
    }
    
    if( McpsIndication->RxData == true )
    {
        switch( port )
        {
        case 1: // The application LED can be controlled on port 1 or 2
        case 2:            
            break;
        case 224:
            PrepareComplianceTestFrame( McpsIndication );            
            break;
        default:
            break;
        }
    }

    IsRxUpdate = true;

}

/*!
 * \brief   MLME-Confirm event function
 *
 * \param   [IN] MlmeConfirm - Pointer to the confirm structure,
 *               containing confirm attributes.
 */
void MlmeConfirm( MlmeConfirm_t *MlmeConfirm )
{
    if( MlmeConfirm->Status == LORAMAC_EVENT_INFO_STATUS_OK )
    {
        switch( MlmeConfirm->MlmeRequest )
        {
            case MLME_JOIN:
            {
                // Status is OK, node has joined the network
                IsNetworkJoinedStatusUpdate = true;
                break;
            }
            case MLME_LINK_CHECK:
            {
                // Check DemodMargin
                // Check NbGateways
                if( ComplianceTest.Running == true )
                {
                    ComplianceTest.LinkCheck = true;
                    ComplianceTest.DemodMargin = MlmeConfirm->DemodMargin;
                    ComplianceTest.NbGateways = MlmeConfirm->NbGateways;
                }
                break;
            }
            default:
                break;
        }
    }

    // Schedule next packet transmission
    TimerSetValue( &TxNextPacketTimer, OVER_THE_AIR_ACTIVATION_DUTYCYCLE );
    TimerStart( &TxNextPacketTimer );

    DeviceState = DEVICE_STATE_SLEEP;
}