/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: End device comissioning parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __LORA_COMISSIONING_H__
#define __LORA_COMISSIONING_H__

/*!
 * When set to 1 the application uses the Over-the-Air activation procedure
 * When set to 0 the application uses the Personalization activation procedure
 */
#define OVER_THE_AIR_ACTIVATION                     1

/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK                      true

#if( OVER_THE_AIR_ACTIVATION != 0 )

/*!
 * Mote device IEEE OUI (big endian)
 * \remark This is unique to a company or organization
 */
#define IEEE_OUI                                    0x00, 0x00, 0x00

/*!
 * Mote device IEEE EUI (big endian)
 *
 * \remark In this application, if the last 4 bytes are all 0, then the 32 bit address is automatically generated using a pseudo random generator seeded with a value derived from BoardUniqueId value
 * If provided by user, e.g. { IEEE_OUI, 0x00, 0x00, 0x00, 0xFF, 0x01 }, then this value is used by the application
 */
#define LORAWAN_DEVICE_EUI                          { IEEE_OUI, 0x00, 0x00, 0x00, 0x00, 0x00 }
//#define LORAWAN_DEVICE_EUI                          { IEEE_OUI,   0x00, 0x3D, 0x03, 0x4A, 0x33 }

/*!
 * Application IEEE EUI (big endian)
 */
#define LORAWAN_APPLICATION_EUI                     { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }
//#define LORAWAN_APPLICATION_EUI                     { 0xCA, 0xB1, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00 }

/*!
 * AES encryption/decryption cipher application key
 */
#define LORAWAN_APPLICATION_KEY                     { 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff }
//#define LORAWAN_APPLICATION_KEY                     { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C }
//#define LORAWAN_APPLICATION_KEY                       { 0x6c, 0xe4, 0x98, 0x66, 0x50, 0xd6, 0x0c, 0x36, 0x4a, 0x54, 0x6a, 0xb5, 0xfe, 0xfe, 0x5f, 0x81 }

#else

/*!
 * Device address on the network (big endian)
 *
 * \remark In this application, if the value is 0, then the address is automatically generated using a pseudo random generator seeded with a value derived from BoardUniqueId value
 * If provided by user, e.g. 0x78563412, then this value is used by the application
 */
#define LORAWAN_DEVICE_ADDRESS                      ( uint32_t )0x0

/*!
 * AES encryption/decryption cipher network session key
 */
#define LORAWAN_NWKSKEY                             { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C }

/*!
 * AES encryption/decryption cipher application session key
 */
#define LORAWAN_APPSKEY                             { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C }

#endif


#endif // __LORA_COMISSIONING_H__
