// EDP & mbed demonstration program using I2C and PWM: W.G.Marshall 2010
// Requires EDP-AM-MC1 DC motor module
// Uses SRF08 Ultrasonic Range Finder on I2C address 0xE0
// Option link J217 on EDP mbed carrier changed from 1-2 to 2-3
// Jumpers on EDP MC1 module will require setting to suit GPIO signals

#include "mbed.h"

I2C sonar(p9, p10);                         // Define SDA, SCL pins
Serial pc(USBTX, USBRX);                    // Define Tx, Rx pins
PwmOut motor(p23);                          // Define PWM output (EDP: EVG0_GPIO40)
DigitalOut Brake(p19);                      // Define brake      (EDP: GPIO0)
DigitalOut Direction(p24);                  // Define direction  (EDP: EVG1_GPIO42)
DigitalOut L1(LED1);                        // User LEDs form bargraph
DigitalOut L2(LED2);
DigitalOut L3(LED3);
DigitalOut L4(LED4);

const int addr = 0xE0;                      // I2C device address for SRF08
char cmd[2];
char echo[3];
// echo[0] = light level
// echo[1] = MSB echo
// echo[2] = LSB echo
float temp8;
float range;   
float MotorPWM;

int main() {

// Set up SRF08 max range and receiver sensitivity
    cmd[0] = 0x02;                          // Range register
    cmd[1] = 0x1C;                          // Set max range about 100cm
    sonar.write(addr, cmd, 2);
    cmd[0] = 0x01;                          // Receiver gain register
    cmd[1] = 0x1B;                          // Set max receiver gain
    sonar.write(addr, cmd, 2);

// Set up PWM and motor control
    motor.period(0.00005);                  // Set PWM frequency = 20kHz
    motor.write(1);                         // Motor speed = 0
    Brake = 0;                              // Brake on = 1, Brake off = 0
    Direction = 0;
   
    printf("\n\n\rCollision Avoidance Program Vsn 1.2\n\r");
    printf("\n\r Range   Light\n\r");
    
    while (1) {
    
// Get range data and light level from SRF08
// Send Tx burst command over I2C bus
        cmd[0] = 0x00;                      // Command register
        cmd[1] = 0x51;                      // Ranging results in cm
        sonar.write(addr, cmd, 2);          // Send ranging burst

        wait(0.07);

// Read back light level and range over I2C bus
        cmd[0] = 0x01;                      // Address of light level
        sonar.write(addr, cmd, 1, 1);       // Send address of light level       
        sonar.read(addr, echo, 3);          // read light and echo result
        
// Generate PWM mark/space ratio from range data
        range = (echo[1]<<8)+echo[2];
        MotorPWM = range/100;               // Turn range into PWM ratio
        if (temp8 != 0) {
           motor.write(1-MotorPWM);         // Update PWM ratio (0 -> 1.0)
        }
        else {
           motor.write(1);                  // PWM ratio = 0
        }
        pc.printf("  %3.0f", range);
        pc.printf("     %3d\r", echo[0]);
        
// Keyboard input to toggle start/stop motor
        if (pc.readable()) {                // Check for keyboard input
           pc.getc();                       // Key pressed, clear buffer 
           if (temp8 == 0) {                // Motor already stopped?
              Brake = 0;                    // Brake off, start motor
              temp8 = range;
           }
           else {                           // Motor running
              Brake = 1;                    // Brake on, stop motor
              temp8 = 0;
           }
        }
        wait(0.1);                          // Wait for 100ms

// Bargraph with mbed user LEDs
        if (range > 70) {
           L1 = 1, L2 = 1, L3 = 1, L4 = 1;
        }
        else if (range > 40) {
           L1 = 1, L2 = 1, L3 = 1, L4 = 0;
        }
        else if (range > 25) {
           L1 = 1, L2 = 1, L3 = 0, L4 = 0;
        }
        else if (range > 7) {
           L1 = 1, L2 = 0, L3 = 0, L4 = 0;
        }
        else {
           L1 = 0, L2 = 0, L3 = 0, L4 = 0;
        }
    }
}
