#include "mbed.h"
#include "bloc_io.h"
#define PI 3.14159
#define R 0.22 //Roue de 22cm de rayon 
#define p 20 //Nombre de paires de pôles du mot 
int w=1;
float I;
float K=0.13;
float G=0.9/K;
float erreur;
float commande;
DigitalOut myled(LED1);
//AnalogIn poignée (p17);
Serial pc(USBTX, USBRX);
//DigitalOut valid_pwm(p21);
Bloc_IO MyPLD(p25, p26, p5, p6, p7, p8, p9, p10, p23, p24);
InterruptIn valid(p22);
Ticker calcul;
Ticker Affiche;
LocalFileSystem local("local");
FILE *fp = fopen("/local/mesures.txt", "w");

void CptFronts(void);
void CalculF(void); //F pour la fonction
//void Calibration(void);
//void AfficheF(void); //F pour la fonction

//int Pwmref = 0;
int Val=10;
int gflag=0;
int Cpt = 0;
int Freq=0;
float Vitesse = 0;
//float GazMin = 0, GazMax = 0;


int main()
{
    int Cpt50Ms=0;
    char cchoix = 'a';
    valid.rise(&CptFronts);// Pour chaque front montant
    valid.fall(&CptFronts);// Pour chaque front descendant
    calcul.attach(&CalculF, 0.05); //appel calcul toutes les 0.1s

    while(true) {
        if(gflag==true) {
          fprintf(fp,"%g ; %d \n", Vitesse,Val );
            
            gflag=false;


            Cpt50Ms++;
            switch(cchoix) {

                case 'a' : {
                    
                    if(Cpt50Ms>=80) {
                        cchoix='b';
                        Cpt50Ms=0;
                    }
                    break;
                }
                case 'b' : {
                    Val=13;
                   
                    if(Cpt50Ms>=80) {
                        cchoix='c';
                    }
                    break;
                }
                case 'c' : {
                   fclose(fp);
                    Val=10;
                    
                }
                
            }
        }

    }
}
void CalculF()
{

    Vitesse = Cpt*10*( (2*PI*R)*3.6)/(6*p) ; // compteur du nb de fronts mais il faut multiplié par 10 pour l'unité (100ms*10=1s), (1tours 3.6/6 pour les m/s)
    Freq=Cpt;
    erreur=Val-Vitesse;
    
    I=I+w*erreur*(0.05/0.03);
    
   
    commande=G*(erreur+I);
    if(commande>255)
    {
        w=0;
        }
        else 
        {
            w=1;
        }
    if (commande>255)
      commande=255;     
   if (commande<0)
    commande = 0;
    MyPLD.write(commande);
    Cpt = 0; //RAZ
    gflag=1;

}
void CptFronts(void)
{
    Cpt++;
}
/*void AfficheF(void)
{
    pc.printf("Vitesse : %f m/s \n\r", Vitesse); //Affiche de la vitesse en ms
    pc.printf("Frequ=cpt : %d \n\r",
}*/