#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
PwmOut venti(p21,"venti");
AnalogIn pot(p19, "capteur_temp");


LocalFileSystem fs("webfs");

EthernetNetIf eth;  
HTTPServer svr;

int main() {
  venti.period(0.001); 
  Base::add_rpc_class<DigitalOut>();
  Base::add_rpc_class<DigitalIn>();

  printf("Setting up...\n\r");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n\r", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
  
  svr.addHandler<SimpleHandler>("/hello");
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/files");
  svr.addHandler<FSHandler>("/");
  svr.addHandler<MyOwnHandler>("/rw");
 
  
  svr.bind(80);
  
  printf("Listening...\n\r");
    
  Timer tm;
  tm.start();
  while(true)
  {
    x=pot.read(); //déclaration d'une variable X pour lire la valeur avec la requete RW (alternatif)
    Net::poll();
    if(tm.read()>.5)
    {
      venti.write(0.1);
      wait(0.5);
      venti.write(0.5);
      led1=!led1;
      tm.start();
      if(x>10){ led2=1;
      }else{
          led2=0;
          }
    }
  }
}
