#include "mbed.h"
#include "AudioAnalyzer.h"

namespace NK
{

void AudioAnalyzer::analyze()
{
    if (analyzed) return;

    // compute the sum of the squares of the input samples
    power = 0;
    zeroCrossings = 0;
    minValue = 127;
    maxValue = -128;
    int8_t const * const lastSample = samples + nsamples - 1;
    bool sign, lastSign = samples[0] < 0;
    for (int8_t const *p = samples; p <= lastSample; p++) {
        int8_t val = *p++;
        power += ((int16_t)val * val);
        sign = (val < 0);
        if (sign != lastSign)
            zeroCrossings++;
        lastSign = sign;
        if (val > maxValue)
            maxValue = val;
        if (val < minValue)
            minValue = val;
    }
    // normalize power
    power /= nsamples;
    analyzed = true;
}

}