/* mbed TextLCD Library Base Class
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 * Modified by Ned Konz to provide better support for 4-line LCDs and ones with other controller chips.
 */
#include "TextDisplay.h"

#ifndef MBED_TEXTLCD_H
#define MBED_TEXTLCD_H

class TextLCD : public TextDisplay {
	public:
		TextLCD(PinName rs, PinName rw, PinName e,
			    PinName d0, PinName d1, PinName d2, PinName d3,
				uint16_t rows = 2, uint16_t columns = 16);
		virtual void character(uint16_t column, uint16_t row, int c);
		virtual uint16_t rows() { return _rows; }
		virtual uint16_t columns() { return _columns; }
		virtual void reset();
		virtual void cls();

		// locate, putc, printf come from parent class

	protected:
		void writeByte(uint16_t value);
		void writeHalfByte(uint16_t value);
		void writeCommand(uint16_t command);
		void writeData(uint16_t data);
		uint16_t readAddressAndBusy();
		void waitUntilDone();

		DigitalOut _rw, _rs, _e;
		BusInOut _d;
		uint16_t _rows, _columns;
};

#endif
