/* mbed Terminal TextDisplay Library
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * Modified by Ned Konz
 * to add baud rate setting
 *
 * Implementation of a TextDisplay using a VT100 Terminal and 
 * escape codes (e.g. Teraterm, Hyperterminal)
 */

#include "TextDisplay.h"

#ifndef MBED_TERMINAL_H
#define MBED_TERMINAL_H

class Terminal : public TextDisplay {
public:

    Terminal(PinName tx, PinName rx);

    virtual void character(uint16_t column, uint16_t row, int c);
    virtual uint16_t rows(); 
    virtual uint16_t columns();  

    virtual void cls();
    virtual void foreground(uint32_t colour);
    virtual void background(uint32_t colour);
    virtual void baud(uint16_t newbaud) { _serial.baud(newbaud); }

protected:

    Serial _serial;
    
};

#endif
