#include "mbed.h"
#include "SDFileSystem.h"
 
// PTD0 D10 – Used for CS of SPI
// PTD2 D11 – Used for MOSI of SPI
// PTD3 D12 – Used for MISO of SPI
// PTC5     – Used for SCK of SPI

// PTC5 is also usable as SCK (J1/09)

//              MOSI, MISO, SCLK, CS, name
SDFileSystem sd(PTD2, PTD3, PTC5, PTD0, "sd");

int main() {
    printf("Hello World!\n");   
 
    mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!");
    fclose(fp); 
 
    printf("Goodbye World!\n");
}
