// Derived from Simon Ford's RPC demo program,
// this adds line editing and help to the RPC over serial over USB operation.
#include "mbed.h"
#include "rpc.h"
#include "getline.h"

Serial pc(USBTX, USBRX);    // 9600/n/8/1

char command[256] = {0};
char response[256] = {0};

// print a summary of classes and objects and their methods
void usage()
{
    pc.puts("/<class>/new pin [pin [...]] [objname] => objname\n\r");
    pc.puts("/<objname>/<method> [arg [arg ...]]\n\r");
    char resp2[256];
    rpc("/", resp2);
    char *p = strtok(resp2, " ");
    while (*p)
    {
        command[0] = '/';
        strcpy(command+1, p);
        strcat(command, "/");
        rpc(command, response);
        pc.puts(command);
        pc.puts(" : ");
        pc.puts(response);
        pc.puts("\n\r");
        p = strtok(NULL, " ");
    }
}

int main()
{
    // setup the classes that can be created dynamically
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<SPI>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();

    pc.puts("type help for help\n\r");
   
    // receive commands, and send back the responses
    for (;;)
    {
        if (getline(pc, command, 256) > 0)
        {
            if (!strcmp(command, "help"))
                usage();
            else
            {
                rpc(command, response);
                if (strlen(response) > 0)
                {
                    pc.putc('[');
                    pc.puts(response);
                    pc.puts("]\n\r");
                }
            }
            pc.puts("> ");
        }
        else
        {
            pc.puts("?\n\r> ");
        }
    }
}
