#include "mbed.h"
#include "audio.h"

namespace NKAudio
{

AnalogOut speaker(AUDIO_DAC_PIN);
Ticker sampleTicker;

// audio samples
// class static
int8_t const * volatile AudioPlayer::nextSample;

// class static
uint16_t volatile AudioPlayer::samplesRemaining;

// interrupt handler
// class static
void AudioPlayer::playAudioSample()
{
    static uint16_t dcBias = DC_BIAS;
    if (samplesRemaining)
    {
        int8_t val     = *nextSample++;
        uint16_t val16 = dcBias + (val * 256);
        speaker.write_u16(val16);
        samplesRemaining--;
    }
    else
    {
        sampleTicker.detach();
        speaker.write_u16(dcBias);
    }
}

bool AudioPlayer::playAudio(int8_t const *start, uint16_t nsamples, AudioCallback cb)
{
    if (!audioDone())
    {
        return false;
    }
    nextSample       = start;
    samplesRemaining = nsamples;
    sampleTicker.attach_us(&playAudioSample, SAMPLE_PERIOD_US);
    while (samplesRemaining)
    {
        if (cb != NULL)
        {
            cb();
        }
        wait_us(AUDIO_WAIT_DURATION_US);
    }
    return true;
}

} // namespace NKAudio
