#ifndef __included_audio_h
#define __included_audio_h

#include <stdint.h>

#ifndef AUDIO_DAC_PIN
#define AUDIO_DAC_PIN PTE30          // J10/11 on FRDM-KL25Z
#endif

namespace NKAudio
{

struct AudioFile
{
    const unsigned char *data;
    unsigned int length;
};

extern const AudioFile audioFiles[];

// Analog:
// GND   J3/14
// VrefH J3/16
// output J10/11, PTE30

const unsigned SAMPLE_RATE_HZ         = 8000;
const unsigned SAMPLE_PERIOD_US       = (1000000U / SAMPLE_RATE_HZ);
const unsigned SAMPLE_BUFFER_SIZE     = 14000;
const unsigned AUDIO_WAIT_DURATION_US = 10000;
const uint16_t DC_BIAS                = 0x8000;

typedef void (*AudioCallback)();

class AudioPlayer
{
public:
    static unsigned numberOfFiles()
    {
        static unsigned nFiles;
        if (!nFiles) {  // count files first time
            for (AudioFile const *p = audioFiles; p->data != NULL; p++) {
                nFiles++;
            }
        } else {
            return nFiles;
        }
    }

    static bool playFileNumbered(unsigned n, AudioCallback cb = NULL)
    {
        n %= numberOfFiles();
        return playAudio(reinterpret_cast<int8_t const * const>(audioFiles[n].data), audioFiles[n].length, cb);
    }

    static bool playAudio(int8_t const *start, uint16_t nsamples, AudioCallback cb = 0);

    static bool audioDone() { return !samplesRemaining; }

private:
    static void playAudioSample();
    static int8_t const * volatile nextSample;
    static uint16_t volatile samplesRemaining;
};

} // namespace NKAudio

#endif
