#include "mbed.h"
#include "WS2811.h"
#include "Colors.h"

const unsigned nLEDs = 60*4;

const PinName dataOutput = PTD2;
const PinName sckOutput = PTD1;
SPI_Type *spiPort = SPI0;

DigitalOut debugOut(PTD3);
Serial pc(USBTX, USBRX);

// @brief sets different colors in each of the LEDs of a strip
// @param strip the light strip
// @param sat saturation, 0.0 - 1.0
// @param brite brightness, 0.0 - 1.0
// @param hueShift shift, 0.0 - 1.0 is equivalent to 0 - 360 degrees
void showRainbow(WS2811 &strip, float sat, float brite, float hueShift)
{
    unsigned nLEDs = strip.numPixels();
    for (unsigned i = 0; i < nLEDs; i++) {
        uint8_t r, g, b;
        float hue = ((float)i / (float)nLEDs) + hueShift;
        HSBtoRGB(hue, sat, brite, &r, &g, &b);
        strip.setPixelColor(i, LedStrip::Color(r, g, b));
    }
    strip.begin();
}
void showTestPattern(WS2811 &strip)
{
    unsigned nLEDs = strip.numPixels();
    for (unsigned i = 0; i < nLEDs; i++) {
        strip.setPixelColor(i, LedStrip::Color(0xff,0,0x55));
    }
    strip.show();
}
void dump_spi_settings(SPI_Type const *spi)
{
    pc.printf("SPI C1=%#02x, C2=%#02x, BR=%d, S=%#02x, D=%#02x, M=%02x\r\n", spi->C1, spi->C2, spi->BR, spi->S, spi->D, spi->M);
    pc.printf("DMA DSR_BCR=%#08lx, SAR=%p, DAR=%p, DCR=%#08lx\r\n",
              (unsigned long)DMA0->DMA[0].DSR_BCR,
              DMA0->DMA[0].SAR,
              DMA0->DMA[0].DAR,
              DMA0->DMA[0].DCR);
}

int main(void)
{
    pc.baud(115200);
    pc.printf("LEDs: %d\r\n", nLEDs);
    debugOut = 0;

    //                NLEDs  MOSI        SCK
    WS2811 lightStrip(nLEDs, spiPort, dataOutput, sckOutput);

    lightStrip.begin();
    dump_spi_settings(spiPort);

    // float sat = 1.0;
    // float brite = 0.25;
    // float hueShift = 0.0;
    // float hueShiftIncrement = 1.0 / (360.0 / 30.0);
    for (;;) {
        // debugOut = 1;
        // showRainbow(lightStrip, sat, brite, hueShift);
        showTestPattern(lightStrip);

        // debugOut = 0;
        // hueShift += hueShiftIncrement;
   }
}