// Mbed library to control WS2801-based RGB LED Strips
// some portions (c) 2011 Jelmer Tiete
// This library is ported from the Arduino implementation of Adafruit Industries
// found at: http://github.com/adafruit/LPD8806
// and their strips: http://www.adafruit.com/products/306
// Released under the MIT License: http://mbed.org/license/mit
//
/*****************************************************************************/

// Heavily modified by Jas Strong, 2012-10-04
// Changed to use a virtual base class and to use software SPI.

#include "mbed.h"
#include "LedStrip.h"
#ifndef MBED_WS2811_H
#define MBED_WS2811_H

#ifdef TARGET_KL25Z
// SPI0 max frequency = fBUS/2 = 24MHz
// SPI1 max frequency = fSYS/2 = 12MHz
// but watch out for SPI1 errata using DMA!
// SPI0: PTA16, PTA17, PTC6, PTC7, PTD2, PTD3
// SPI1: PTB16, PTB17, PTD6, PTD7, PTE1, PTE3
#define MOSI_DEFAULT PTD2
// SPI0: PTA15, PTC5, PTD1/ LED_BLUE
// SPI1: PTB11, PTD5, PTE2
#define SCLK_DEFAULT PTD1
#else
#endif

class WS2811 : public LedStrip
{
public:
    WS2811(int n, SPI_Type *_spi, PinName mosi = MOSI_DEFAULT, PinName sclk = SCLK_DEFAULT);
    virtual void begin(void);
    virtual void show(void);
    virtual void blank(void);

private:
    SPI_Type *spi;
    PinName mosi;
    uint8_t dmaBytes[16*3]; // enough for DMA'ing 1 RGB LED

    Timer guardtime;

    void writePixel(uint8_t *p);
    void writeByte(uint8_t byte, uint8_t *dest);
    void startDMA();
};
#endif