// Mbed library to control WS2801-based RGB LED Strips
// some portions (c) 2011 Jelmer Tiete
// This library is ported from the Arduino implementation of Adafruit Industries
// found at: http://github.com/adafruit/LPD8806
// and their strips: http://www.adafruit.com/products/306
// Released under the MIT License: http://mbed.org/license/mit
//
/*****************************************************************************/

// Heavily modified by Jas Strong, 2012-10-04
// Changed to use a virtual base class and to use software SPI.

#include "mbed.h"
#include "LedStrip.h"
#ifndef MBED_WS2811_H
#define MBED_WS2811_H

#ifdef TARGET_KL25Z
#define MOSI_DEFAULT PTD2
#define SCLK_DEFAULT PTC5
#else
#endif

class WS2811 : public LedStrip
{
public:
    WS2811(int n, PinName mosi = MOSI_DEFAULT, PinName sclk = SCLK_DEFAULT);
    virtual void begin(void);
    virtual void show(void);
    virtual void blank(void);

private:
    SPI spi;            // to do actual communication

    Timer guardtime;
    uint32_t bogocal;

    void write(uint8_t byte);
    void writebit(bool bit);
    void celldelay(void);
};
#endif