// 800 KHz WS2811 driver, kinda.
//
// Parameterized and modified to use soft SPI.
// Jas Strong <jasmine@electronpusher.org>
// Modified to use hard SPI by Ned Konz <ned@bike-nomad.com>
/*****************************************************************************/

#include "LedStrip.h"
#include "WS2811.h"

WS2811::WS2811(int n, PinName mosi, PinName sclk) :
    LedStrip(n),
    spi(mosi, NC, sclk)
{
#ifdef TARGET_KL25Z
    spi.format(8, 3);
#else
    spi.format(16, 3);
#endif
    spi.frequency(800e3 * 16);  // 12.8 MHz => 800KHz bit rate
}

/*
 *  These chips use a one-wire protocol based on a sort of NRZ signalling- jas.
 */

inline void WS2811::writebit(bool bit)
{
    if (bit) {
#ifdef TARGET_KL25Z
        spi.write(0xff);    // 8 high
        spi.write(0x00);    // 8 low
#else
        spi.write(0xff00);
#endif
    } else {
#ifdef TARGET_KL25Z
        spi.write(0xe0);    // 3 high, 5 low
        spi.write(0x00);    // +8 low
#else
        spi.write(0xe000);
#endif
    }
}

void WS2811::write(uint8_t byte)
{
    writebit(byte & 0x80);
    writebit(byte & 0x40);
    writebit(byte & 0x20);
    writebit(byte & 0x10);
    writebit(byte & 0x08);
    writebit(byte & 0x04);
    writebit(byte & 0x02);
    writebit(byte & 0x01);
}

void WS2811::begin(void)
{
    blank();
    show();
}

void WS2811::blank(void)
{
    memset(pixels, 0x00, numPixelBytes());
}

void WS2811::show(void)
{
    uint16_t i, nl3 = numPixelBytes(); // 3 bytes per LED
    while (guardtime.read_us() < 50)
        /* spin */;
    __disable_irq();
    for (i=0; i<nl3; i++ ) {
        write(pixels[i]);
    }
    __enable_irq();
    guardtime.reset();
}


