// Mbed library to control WS2801-based RGB LED Strips
// some portions (c) 2011 Jelmer Tiete
// This library is ported from the Arduino implementation of Adafruit Industries
// found at: http://github.com/adafruit/LPD8806
// and their strips: http://www.adafruit.com/products/306
// Released under the MIT License: http://mbed.org/license/mit
//
/*****************************************************************************/

// Heavily modified by Jas Strong, 2012-10-04
// Changed to use a virtual base class and to use software SPI.

#include "mbed.h"
#include "LedStrip.h"
#ifndef MBED_WS2811_H
#define MBED_WS2811_H


class WS2811 : public LedStrip {

 public:

  WS2811(PinName dataPin, PinName clockPin, int n);
  virtual void begin(void);
  virtual void show(void);
  virtual void blank(void);
  virtual void setPixelColor(uint16_t n, uint8_t r, uint8_t g, uint8_t b);
  virtual void setPackedPixels(uint8_t * buffer, uint32_t n);
  virtual void setPixelB(uint16_t n, uint8_t b);
  virtual void setPixelG(uint16_t n, uint8_t g);
  virtual void setPixelR(uint16_t n, uint8_t r);
  virtual void setPixelColor(uint16_t n, uint32_t c);
  virtual uint16_t numPixels(void);
  virtual uint32_t Color(uint8_t, uint8_t, uint8_t);
  virtual uint32_t total_luminance(void);

 private:
  DigitalOut dat;
  DigitalOut clk;
  __IO uint32_t *data_set;
  __IO uint32_t *clock_set;
  __IO uint32_t *data_clr;
  __IO uint32_t *clock_clr;
  uint32_t clock_mask;
  uint32_t data_mask;
  void write(uint8_t byte);
  void writebit(bool bit);
  void celldelay(void);
  uint8_t *pixels;     // Holds LED color values
  uint16_t numLEDs;     // Number of RGB LEDs in strand
  Timer guardtime;
  uint32_t bogocal;
    
};
#endif