#include "mbed.h"
#include "WS2811.h"
#include "Colors.h"

// per LED: 3 * 20 mA = 60mA max
// 60 LEDs: 60 * 60mA = 3600 mA max
unsigned const nLEDs = MAX_LEDS_PER_STRIP;

// I/O pin usage
// PTD0 TPM0 CH0 monitor
// PTD1 TPM0 CH1 monitor
// PTD2 data output
// PTD3 debug output

unsigned const DATA_OUT_PIN = 2; // PTD2

Serial pc(USBTX, USBRX);

// @brief sets different colors in each of the LEDs of a strip
// @param strip the light strip
// @param sat saturation, 0.0 - 1.0
// @param brite brightness, 0.0 - 1.0
// @param hueShift shift, 0.0 - 1.0 is equivalent to 0 - 360 degrees
static void showRainbow(WS2811 &strip, float sat, float brite, float hueShift)
{
    unsigned nLEDs = strip.numPixels();
    for (unsigned i = 0; i < nLEDs; i++) {
        uint8_t r, g, b;
        float hue = ((float)i / (float)nLEDs) + hueShift;
        HSBtoRGB(hue, sat, brite, &r, &g, &b);
        strip.setPixelColor(i, LedStrip::Color(r, g, b));
    }
    strip.show();
}

int main(void)
{
    pc.baud(115200);
    WS2811 lightStrip(nLEDs, DATA_OUT_PIN);

    lightStrip.begin();

    float brite = 0.2;  // 1.0 is full brightness, which is VERY bright!
    float rainbowPeriod = 1 * 1.0e6; // usec
    float sat = 1.0;

    Timer timeRunning;
    timeRunning.start();
    bool printed = false;
    unsigned frames = 0;

    for (;;) {
        unsigned running = timeRunning.read_us();
        float hueShift = running / rainbowPeriod;
        if (!printed && running >= 10000000U) {
            pc.printf("%u frames in %u usec = %u frames / sec\r\n", frames, running, frames * 1000000 / running);
            printed = true;
        }
        showRainbow(lightStrip, sat, brite, hueShift);
        frames ++;
    }
}

