#include "billybass.hpp"
#include "SDFileSystem.h"
#include "song.hpp"
#include "player.hpp"
#include "action.hpp"
#include <ctype.h>

//                 tailPin,  mouthPin, bodyPin   inverted
// BillyBass testBass(LED_RED, LED_GREEN, LED_BLUE, true);

//                 tailPin,        mouthPin,      bodyPin
BillyBass bass1(BASS1_TAIL,     BASS1_MOUTH,   BASS1_BODY);
//                 tailPin,        mouthPin,      bodyPin
BillyBass bass2(BASS2_TAIL,     BASS2_MOUTH,   BASS2_BODY);
DigitalIn button1(BASS1_BUTTON);    // J3/4
DigitalIn button2(BASS2_BUTTON);   // J3/2

// Analog:
// GND   J3/14
// VrefH J3/16
AnalogOut speaker(PTE30);              // J10/11

//                 MOSI,    MISO,    SCLK,    CS, name
SDFileSystem sd(SD_MOSI, SD_MISO, SD_SCLK, SD_CS, SD_NAME);
Serial pc(USBTX, USBRX);

Timer t;

void serialIrqHandler()
{
    int c = pc.getc();
    bool isLower = islower(c);
    c = toupper(c);
    DigitalOut *out = 0;
    float elapsed = t.read();
    t.reset();
    pc.printf("%d %f\r\n", (int)!isLower, elapsed);

    switch (c) {
        case 'H':
        case 'B':
            out = bass1.outputNamed("body");
            break;
        case 'T':
            out = bass1.outputNamed("tail");
            break;
        case 'M':
            out = bass1.outputNamed("mouth");
        default:
            break;
    }
    if (out) {
        if (isLower)
            out->write(0);
        else
            out->write(1);
    }
}

int main()
{
    SongPlayer player;
    pc.baud(SERIAL_BAUD);
    t.start();
    pc.attach(serialIrqHandler);
    button1.mode(PullUp);
    button2.mode(PullUp);

    fprintf(stderr, "*** REBOOT ***\r\n");

    for (;;) {
        // read the directory
        DIR *bassDir = 0;
        while (!bassDir) {
            if ((bassDir = opendir(BASS_DIRECTORY)) != 0)
                break;
            pc.printf("Error opening " BASS_DIRECTORY "\r\n");
            wait(1.0);
        }

        while (dirent *d = readdir(bassDir)) {
            Song *song = Song::newSong(d->d_name);
            if (song) {
                fprintf(stderr, "Waiting to play %s\r\n", song->getSampleFileName());
                while (!(!button1 || !button2))
                    wait(0.1);
                player.playEntireSong(song);
                fprintf(stderr, "total length: %f done: %u\r\n", player.timeInSong, player.actionsDone);
            }
        }
        closedir(bassDir);
        fprintf(stderr, "Done.\r\n");
    }
}

