#ifndef __included_billybass_hpp
#define __included_billybass_hpp

#include "mbed.h"
#include "config.hpp"
#include <list>
#include <vector>
#include <cmath>
#include "mbed_debug.h"

class BillyBass
{
public:

    BillyBass(PinName tailPin, PinName mouthPin, PinName bodyPin, bool _inverted=false) :
        tail(tailPin), mouth(mouthPin), body(bodyPin), inverted(!!_inverted) {
        relax();
        if (numFish < MAX_FISH) fish[numFish++] = this;
        else fprintf(stderr, "Too many fish!\r\n");
    }

    // if *_pName, it will get the string name of the output
    DigitalOut *outputNamed(char const *_outputName, char const **_pName = 0, float *_pOnDelay = 0, float *_pOffDelay = 0, float *_pMinOn = 0);

    static BillyBass *bassNumber(unsigned which) {
        return (which >= numFish) ? 0 : fish[which];
    }

    static unsigned getNumFish() {
        return numFish;
    }

    int onState() const {
        return !inverted;
    }
    int offState() const {
        return inverted;
    }

    void relax() {
        tail.write(offState());
        mouth.write(offState());
        body.write(offState());
    }
    char const * outputName(DigitalOut const *out) const;

protected:
    static BillyBass* fish[ MAX_FISH ];
    static unsigned numFish;
    static char const * mouthName;
    static char const * bodyName;
    static char const * tailName;

    DigitalOut tail;
    DigitalOut mouth;
    DigitalOut body;
    int inverted;
};

#endif
