// copy this to config.hpp and edit as needed
#ifndef __included_config_hpp
#define __included_config_hpp

// configuration for Billy Bass
#define MAX_FISH 2

// SD card layout: all files in BASS_DIRECTORY ("/sd/SD_Files/")
//
// Each pair of files in that directory are named like:
//      "<seqnum>_<fishnum>_filename.raw"   (16-bit mono raw little-endian samples, sample rate=SAMPLE_RATE_HZ)
// and
//      "<seqnum>_<fishnum>_filename.txt"   (tab-separated text file with starttime,endtime,<mouth|head|body|tail>
// text files are as exported from Audacity's label tracks
//
#define SD_NAME "sd"
#define SD_ROOT "/" SD_NAME
#define BASS_DIRECTORY SD_ROOT "/SD_Files"
// length of BASS_DIRECTORY without NUL
#define BASS_DIRECTORY_LENGTH 12
#define MAX_BASENAME_LENGTH 30
#define MAX_PATH_LEN \
        BASS_DIRECTORY_LENGTH + 1 \
        + MAX_BASENAME_LENGTH + 1

// limits of .txt files
#define MAX_ACTIONS_LINES_PER_SONG 60
#define MAX_ACTIONS_PER_SONG MAX_ACTIONS_LINES_PER_SONG*2
#define MAX_TEXT_FILE_LENGTH 2048

// define this to 1 to make start times earlier and
// enforce minimum on times
#define FIX_TIMES 0

// Sample configuration
typedef int16_t Sample_t;   // 16-bit raw, LE samples
const float SAMPLE_RATE_HZ = 8000.0;
const unsigned SAMPLE_PERIOD_USEC = (unsigned)(1.0e6/SAMPLE_RATE_HZ);

// Player configuration
const size_t BUFFER_SIZE = 512;
const size_t SAMPLES_PER_BUFFER = BUFFER_SIZE / sizeof(Sample_t);
const float SECONDS_PER_CHUNK = SAMPLES_PER_BUFFER / SAMPLE_RATE_HZ;

#define SERIAL_BAUD 115200
#define ANALOG_OUTPUT_BIAS  0x8000

#define BODY_ON_DELAY 0.65
#define BODY_OFF_DELAY 0.65
#define TAIL_ON_DELAY 0.40
#define TAIL_OFF_DELAY 0.40
#define MOUTH_ON_DELAY 0.10
#define MOUTH_OFF_DELAY 0.10
#define MOUTH_MIN_ON_TIME 0.05

// Power:
// Power GND  J9/14
// Vin (6V)   J9/16

// I/O configuration
#define BASS1_TAIL  PTB0   /* J10/2 */
#define BASS1_MOUTH PTB1   /* J10/4 */
#define BASS1_BODY  PTB2   /* J10/6 */
#define BASS1_BUTTON PTD5  /* J2/4 */

#define BASS2_TAIL  PTB3  /* J10/8 */
#define BASS2_MOUTH PTC2  /* J10/10 */
#define BASS2_BODY  PTC1  /* J10/12 */
#define BASS2_BUTTON PTA13 /* J3/2 */

// SD Card (3.3V)
// PTD0 J2/6 D10 - Used for CS of SPI
// PTD2 J2/8 D11 - Used for MOSI of SPI
// PTD3 J2/10 D12 - Used for MISO of SPI
// PTC5 J1/9  Used for SCLK of SPI (must solder if using shield)
#define SD_MOSI PTD2
#define SD_MISO PTD3
#define SD_SCLK PTC5
#define SD_CS   PTD0

#endif
