
#include "billybass.hpp"
#include <string.h>

// class static
BillyBass* BillyBass::fish[ MAX_FISH ];
unsigned BillyBass::numFish;
char const * BillyBass::mouthName = "mouth";
char const * BillyBass::bodyName = "body";
char const * BillyBass::tailName = "tail";

DigitalOut *BillyBass::outputNamed(char const *_outputName, char const **_pName, float *_pOnDelay, float *_pOffDelay, float *_pMinOnTime)
{
    DigitalOut *output = 0;
    float onDelay = 0.0, offDelay = 0.0, minOnTime = 0.0;
    char const *name = 0;

    if (!strcmp(_outputName, mouthName)) {
        output = &mouth;
        name = mouthName;
        onDelay = MOUTH_ON_DELAY;
        offDelay = MOUTH_OFF_DELAY;
        minOnTime = MOUTH_ON_DELAY / 2;
    } else if (!strcmp(_outputName, "head") || !strcmp(_outputName, bodyName)) {
        output = &body;
        name = bodyName;
        minOnTime = onDelay = BODY_ON_DELAY;
        offDelay = BODY_OFF_DELAY;
    } else if (!strcmp(_outputName, tailName)) {
        output = &tail;
        name = tailName;
        minOnTime = onDelay = TAIL_ON_DELAY;
        offDelay = TAIL_OFF_DELAY;
    }
    if (_pOnDelay) *_pOnDelay = onDelay;
    if (_pOffDelay) *_pOffDelay = offDelay;
    if (_pMinOnTime) *_pMinOnTime = minOnTime;
    if (_pName) *_pName = name;
    return output;
}

char const *BillyBass::outputName(DigitalOut const *out) const
{
    if (out == &tail) return tailName;
    else if (out == &body) return bodyName;
    else if (out == &mouth) return mouthName;
    else return "unknown";
}
