#ifndef __included_song_hpp
#define __included_song_hpp

#include <DirHandle.h>

#include "billybass.hpp"
#include "config.hpp"
#include "action.hpp"

class Song
{
public:
    typedef Action actions_t[ MAX_ACTIONS_PER_SONG ];

    // _name is relative to BASS_DIRECTORY
    // return a pointer to a fully read-in Song if valid
    static Song *newSong(char const *_name);


    void reset() {
        sequenceNumber = 0;
        whichFish = NO_FISH;
        basename = 0;
        extension = 0;
        numActions = 0;
    }

    BillyBass * myFish() {
        return BillyBass::bassNumber(whichFish);
    }
    bool isValid() const {
        return basename != 0 && whichFish != NO_FISH;
    }
    bool parseFilename(char const *_name);
    bool readActions();

    unsigned getSequenceNumber() const {
        return sequenceNumber;
    }
    unsigned getWhichFish() const {
        return whichFish;
    }
    char const *getSampleFileName() {
        if (!extension) return 0;
        strcpy(extension, sampleExtension);
        return fullname;
    }
    char const *getTextFileName() {
        if (!extension) return 0;
        strcpy(extension, textExtension);
        return fullname;
    }
    Action *getActions() {
        return actions;
    }
    bool addAction(float _time, int _state, DigitalOut* _out, char _code);
    
    unsigned getNumActions() const {
        return numActions;
    }

    void print(FILE *f) {
        fprintf(f, "%s fish=%u seq=%u\r\n", getSampleFileName(), whichFish, sequenceNumber);
        Action *lastAction = actions + numActions;
        for (Action *action = actions; action < lastAction; action++) {
            fprintf(f, "%0.02f %s %d\r\n", action->actionTime, myFish()->outputName(action->output), action->desiredState);
        }
    }

protected:
    Song() {
        reset();
    }
    ~Song() {}

    static char const directoryName[ BASS_DIRECTORY_LENGTH + 1 ];
    static unsigned const NO_FISH;
    static char const *textExtension;
    static char const *sampleExtension;
    static Song theSong;

    unsigned sequenceNumber;    // 0-relative
    unsigned whichFish;         // 0-relative
    char fullname[ MAX_PATH_LEN ];  // with directory name
    char *basename;     // points into fullname
    char *extension;    // points into fullname
    actions_t actions;
    unsigned numActions;
};

#endif                                 // __included_song_hpp
